// Mode X Sprite Library
// Copyright (C) 1992 Court Demas  --  court+@cmu.edu

#pragma hdrfile "etc.SYM"
#ifndef ETC_H
#define ETC_H

#define TRUE 1
#define FALSE 0
typedef char BOOL;

/*
A simple class for any object which has a fixed position.
I am using GetX() and GetY() so that I can change the coordinate system later
if I want to (maybe polar? :-)).  I might use fixed-point longs, dividing
each one by 10 or 100 so I could get some accuracy when moving along
diagonals.  Get*() and Set*() would then multiply or divide my that amount
to get the integer value.
*/

class TCoordinate {

  protected:
	int		x,y;

  public:
	TCoordinate() {};
	TCoordinate(int sx,int sy) { x=sx; y=sy; }

	int		GetX(void) 					{ return x; }
	int		GetY(void) 					{ return y; }

	void	SetX(int newx) 				{ x = newx; }
	void 	SetY(int newy)				{ y = newy; }
	void	SetXY(int newx,int newy) 	{ x = newx; y = newy; }
	void 	MoveUp(int dy=1)			{ y -= dy; }
	void 	MoveDown(int dy=1) 			{ y += dy; }
	void	MoveLeft(int dx=1)			{ x -= dx; }
	void 	MoveRight(int dx=1)			{ x += dx; }

};


class TRectangle {
  private:
	TCoordinate		Size;

  public:
	TCoordinate		Start,
					End;


				TRectangle() {}

	void		Set(int sx, int sy, int ex, int ey) {
					Start.SetXY(sx,sy);
					End.SetXY(ex,ey);
					Size.SetX(ex - sx);
					Size.SetY(ey - sy);
				}

	int			GetWidth(void) {
					return Size.GetX();
					}
	int			GetHeight(void) {
					return Size.GetY();
					}

};


// These are specific to how many possible directions you want and should be
// put in a different header.
#define UP 			0
#define UPRIGHT 	1
#define RIGHT 		2
#define DOWNRIGHT 	3
#define DOWN 		4
#define DOWNLEFT 	5
#define LEFT 		6
#define UPLEFT		7

class TVector {

  protected:
	int		dx, dy;

  public:

			TVector(void)				{ dx=0; dy=0; }

	void 	SetDeltaX(int newdx)		{ dx = newdx; }
	void 	SetDeltaY(int newdy)		{ dy = newdy; }
	void	SetDeltaXY(int x, int y)	{ dx=x; dy=y; }
	int		GetDeltaX(void)				{ return dx; }
	int		GetDeltaY(void)				{ return dy; }

};


/*
A class for keeping track of the position and vector of an object.  I might
create an separate Speed_Class, but maybe that's going a little overboard..

Assumes that you want 8 directions - just to be stupid.
*/

class 	TPVector : public TCoordinate, public TVector {


  private:
		int 	maxSpeed,
				minSpeed,
				Speed;

	void	NormSpeed(void) {
				if (Speed < minSpeed) Speed = minSpeed;
				if (Speed > maxSpeed) Speed = maxSpeed;
				}

  public:
			TPVector() : 	TCoordinate(),
							TVector() {}

			TPVector(int smax,int smin) :
					TCoordinate(),
					TVector()
				{
				SetDeltaX(-1);
				SetDeltaY(0);
//				SetDirection(UP);
				maxSpeed	=	smax;
				minSpeed	=	smin;
				Speed 		=	0;
				}


	// Updates the coordinates of the sprite based on speed/direction.
	void	Update_Position(void);

	void	SetMaxSpeed(int _max)	{ maxSpeed = _max; 		}
	void 	SetMinSpeed(int _min)	{ minSpeed = _min; 		}

	void	Faster(int d=1)		{ Speed+=d; NormSpeed(); 	}
	void 	Slower(int d=1)		{ Speed-=d; NormSpeed(); 	}
	void	Stop(void)			{ Speed = 0; 				}

	void	SetSpeed(int s)		{ Speed = s;				}
	int		GetSpeed(void)		{ return Speed; 			}
};

#endif
#pragma hdrstop
//*****************************************************************************
// End of etc.h
