// Hobbes Mode X Sprite Library

#include <conio.h>
#include <stdio.h>
#include <alloc.h>
#include <stdlib.h>
#include "hobbes.h"
#include "sprite.h"


/*
Maybe I should use iostream.h, but it's always seemed a bit sloppy to me.
Load in a bitmap from the file named *filnam, and calls
CreateAlignedMaskedImage() to allocate and copy it to screen memory.
*/
void	TBitmap::Load_Bitmap(char *fname) {

	FILE 	*fptr;
	char	dummy[81];
	int		i,j;

	if ((fptr = fopen(fname,"r")) == NULL) {
		::RestoreTextMode();
		printf("Can't open Bitmap file %s",fname);
		exit(1);
		}

	fscanf(fptr,"%d",&Width);
	fgets(dummy,80,fptr);
	fscanf(fptr,"%d",&Height);
	fgets(dummy,80,fptr);

	if ((Pixels = (char*) malloc (sizeof(char) * Width * Height)) == NULL)
		exit(2);
	if ((Mask = (char*) malloc (sizeof(char) * Width * Height)) == NULL)
		exit(2);

	fgets(dummy,80,fptr);
	for (i=0; i<Width; i++) {
		for (j=0; j<Height; j++) {
			fscanf(fptr,"%d",&(Pixels[i*Width + j]));
			}
		fgets(dummy,80,fptr);
		}

	fgets(dummy,80,fptr);
	for (i=0; i<Width; i++) {
		for (j=0; j<Height; j++) {
			fscanf(fptr,"%d",&(Mask[i*Width + j]));
			}
		fgets(dummy,80,fptr);
		}


//	if (CreateAlignedMaskedImage(&Image,
//				Pixels,
//				Width, Height,
//				Mask) == 0) {
//			RestoreTextMode();
//			printf("Couldn't get memory\n");
//			exit(1);
//		  }

//void CreateAlignedMaskedImage(MaskedImage *ImageToSet, char *Image,
//		int ImageWidth,	int ImageHeight, char *Mask);

	::CreateAlignedMaskedImage(&Image,
				Pixels,
				Width, Height,
				Mask);
	fclose(fptr);
}


void 	TBitmap::Draw(int posX, int posY) {
	CopyScreenToScreenMasked(
		0, 0, Width, Height,
		posX, posY,
		&Image,
		Draw_Offset,
		Virtual_Width_Addr);
}


BOOL	TBitmap::DrawCkHit(int posX, int posY) {
	BOOL hit=FALSE;

	for(int i=posX;(i<posX+Width)&&(!hit);i++)
		for(int j=posY;(j<posY+Height)&&(!hit);j++) {
			hit = (::ReadPixel(i,j) != BLACK);
			}

	if (hit)
		return TRUE;
	  else {
		::CopyScreenToScreenMasked(
			0, 0, Width, Height,
			posX, posY,
			&Image,
			Draw_Offset,
			Virtual_Width_Addr);
			return FALSE;
		}
}


void	TSprite::Load_Sprites(char **fnames, int _numbitmaps) {

	NumBitmaps = _numbitmaps;
	Bitmaps = (TBitmap**) malloc (sizeof(TBitmap*) * NumBitmaps);

	for (int i=0; i<NumBitmaps; i++)
		Bitmaps[i] = new TBitmap(fnames[i]);
}

void TSprite::Draw(void) {
	Update_Position();
	Bitmaps[0]->Draw(GetX(), GetY());
}

void TSprite::Draw(int bnum) {
	Update_Position();
	Bitmaps[bnum]->Draw(GetX(), GetY());
}

void TSprite::Draw(int bnum, int posX, int posY) {
	Update_Position();
	Bitmaps[bnum]->Draw(posX, posY);
}

BOOL TSprite::DrawCkHit(int bnum, int posX, int posY) {
	Update_Position();
	return Bitmaps[bnum]->DrawCkHit(posX, posY);
}

// assumes you want a black background
void TSprite::Erase(void) {
	int width  = Bitmaps[0]->GetWidth(),
		height = Bitmaps[0]->GetHeight();
	RectangleFill(GetX(), GetY(), GetX() + width, GetY() + height,BLACK);
}


//*****************************************************************************
// End of sprite.cpp
