// Hobbes Sprite Library

#pragma hdrfile "sprite.SYM"
#ifndef SPRITE_H
#define SPRITE_H

#include<alloc.h>

#include"hobbes.h"
#include"etc.h"


/*
Should add code to change the origin from (0,0) and the width of the
destination bitmap (to perform clipping).  Maybe in TBitmapClip.

This is a fairly simple class encapsulating a single masked bitmap.  It
can automatically load the bitmap from a file and display it anywhere on the
screen.
*/
class	TBitmap {

  private:
	MaskedImage 		Image;
	char 				*Pixels;
	char				*Mask;
	int					Width, Height;

  public:

			TBitmap() {}
			TBitmap(char *fname) {
				Load_Bitmap(fname);
				}

	void	Load_Bitmap(char*);

	void	Draw(int, int);
	BOOL	DrawCkHit(int, int);

	int		GetWidth(void) 		{ return Width; 	}
	int		GetHeight(void)		{ return Height; 	}
};


//----------------------------------------------------------------------------
//----------------------------------------------------------------------------



/*
This is my first attempt at a Sprite class.

It will:
1) Load the specified masked bitmaps into screen memory.
2) Keep track of where you sprite is, updating its position based on
	the sprites speed and direction.
3) Allow simple animation by having the image of the sprite specified as a
	parameter.  e.g. You have a sprite of a man walking.  Create sprites
	named "man1.bit", "man2.bit" etc., and load them into the sprite.  Then,
	keep a counter of which one is being displayed at the moment, and call
	draw with the number of the bitmap you want displayed.
	I use this in Bolo Binary to store the four different orientations of
	the tanks/eggs/etc.

In the future I would like to add:
1) Clipping
2) Collision detection
	This is tricky because different programs have different concepts of what
	a "hit" is.  Bolo Binary makes the tank blow up if there are any non-black
	pixels where the tank is about to be drawn.  Other programs might just
	check to see if two sprites have touched.
*/

class 	TSprite : public TPVector {
  private:
	TBitmap 		**Bitmaps;
	int				NumBitmaps;

  public:

			TSprite() : TPVector() {}
			TSprite(char **fnames, int _numbitmaps) : TPVector() {
				Load_Sprites(fnames, _numbitmaps);
				}
	void	Load_Sprites(char**, int);

	void	Draw(void);
	void	Draw(int);
	void 	Draw(int bnum, int posX, int posY);
	BOOL 	DrawCkHit(int bnum, int posX, int posY);
	void	Erase(void);
};


#endif
#pragma hdrstop
//*****************************************************************************
// End of sprite.h
