#include <conio.h>
#include <dos.h>
#include "hobbes.h"
#include "tile.h"

void TTile::Draw(int x, int y) {
//	y = y + x/Virtual_Width_Pix;

	switch (Type) {
		case 	BLANK:		break;
		case	SOLID:		RectangleFillAligned(x,y,x+Tile_Width-1,y+Tile_Height-1,Color);
							break;
		case	BITMAP:		BMP->Draw(x,y);
							break;
		}
}


Tile_Handle TTileMap::NewTile(COLOR c) {
	Tiles[NumTiles] = new TTile(SOLID,c);
	Tiles[NumTiles]->Tile_Width = Tile_Width;
	Tiles[NumTiles]->Tile_Height = Tile_Height;
	return NumTiles++;
}


Tile_Handle	TTileMap::NewTile(TBitmap *bmp) {
	Tiles[NumTiles] = new TTile(BITMAP,bmp);
	Tiles[NumTiles]->Tile_Width = Tile_Width;
	Tiles[NumTiles]->Tile_Height = Tile_Height;
	return NumTiles++;
}

void TTileMap::SetTile(int x, int y, Tile_Handle th) {
	HandleMap[x][y] = th;
}


// redraw map where sprite just was
void TTileMap::Dirty(TSprite *spr) {
	int stilex, stiley,
		numx, numy;

	stilex = spr->GetX() / Tile_Width;
	stiley = spr->GetY() / Tile_Height;
	numx = 2;
	numy = 3;

	for(int i=stilex; i<stilex+numx; i++)
		for(int j=stiley; j<stiley+numy; j++)
			Tiles[HandleMap[i][j]]->Draw(i*Tile_Width, j*Tile_Height);
}


void TTileMap::Move(int dx) {
	DisplayStart.SetX(DisplayStart.GetX()+dx);
	MODdeltaX = MODdeltaX+dx*4;
	int fix;
	fix = (DisplayStart.GetX()*4) / MapVirtualPort.GetWidth();

	//move right
	if ((MODdeltaX) > Tile_Width) {
		MODdeltaX %= (Tile_Width);
		LeftLocLimit++;
		RightLocLimit++;
		for (int i=0; i<MapVirtualPort.GetHeight()/Tile_Height; i++) {
			Tiles[HandleMap[RightLocLimit][i]]->Draw(
				(RightLocLimit)*(Tile_Width), i*Tile_Height);
			}
		}
	//move left
	if (MODdeltaX < 0) {
		MODdeltaX += (Tile_Width);
		LeftLocLimit--;
		RightLocLimit--;
		for (int i=0; i<MapVirtualPort.GetHeight()/Tile_Height; i++) {
			Tiles[HandleMap[LeftLocLimit][i]]->Draw(
				(LeftLocLimit)*(Tile_Width), i*Tile_Height);
			}
		}

	SetDisplay(DisplayStart.GetX(), DisplayStart.GetY()); //-fix);
}


void TTileMap::DrawWholeMap(void) {
	int numtilesx,
		numtilesy;

	numtilesx = MapVirtualPort.GetWidth() / Tile_Width;
	numtilesy = MapVirtualPort.GetHeight() / Tile_Height;

	for(int i=-1; i<numtilesx; i++)
		for(int j=0; j<numtilesy; j++)
			Tiles[HandleMap[i][j]]->Draw(i*Tile_Width, j*Tile_Height);

	for(i=-1; i<numtilesx; i++)
		for(int j=0; j<numtilesy; j++)
			Tiles[HandleMap[i][j]]->Draw(i*Tile_Width, j*Tile_Height);
}

//---------------------------------------------------------------------------