// Hobbes Sprite Library
// Court Demas - court+@cmu.edu

#pragma hdrfile "Tile.SYM"
#ifndef TILE_H
#define TILE_H

#include "hobbes.h"
#include "sprite.h"
#include "etc.h"


#define 	MAX_TILES			512
#define		MAX_MAP_WIDTH		200
#define		MAX_MAP_HEIGHT		200

typedef 	unsigned int 		Tile_Handle;
enum Tile_Type { BLANK, SOLID, BITMAP };
typedef enum Tile_Type TILE_TYPE;


class TTile : TBitmap {
  protected:
	TILE_TYPE		Type;
	COLOR			Color;
	TBitmap			*BMP;

  public:
			TTile(TILE_TYPE tt, COLOR c) {
				Type = tt; Color=c;
				}
			TTile(TILE_TYPE tt, TBitmap *bmp) {
				Type = tt; BMP = bmp;
				}

	void	Draw(int x, int y);
	int		Tile_Width,
			Tile_Height;
};



class TTileMap {

  protected:
  public:
	TTile 			*Tiles[MAX_TILES];
	Tile_Handle		NumTiles;
//	Tile_Handle		huge HandleMap[MAX_MAP_WIDTH][MAX_MAP_HEIGHT];
	Tile_Handle		huge **HandleMap;
	int				Tile_Width,
					Tile_Height;
	int				MODdeltaX;
	int				RightLocLimit,
					LeftLocLimit;

	int 			cc;
	TCoordinate		MapLoc;
	TCoordinate		DisplayStart;
	TRectangle		MapDisplayPort;
	TRectangle		MapVirtualPort;

				TTileMap(int w, int h, int dsx, int dsy) {
					HandleMap = (Tile_Handle huge**) farmalloc (sizeof(Tile_Handle*)*MAX_MAP_WIDTH);
					for (int i=0; i<MAX_MAP_HEIGHT; i++)
						HandleMap[i] = (Tile_Handle*) farmalloc (sizeof(Tile_Handle)*MAX_MAP_HEIGHT);
					cc=0;
					NumTiles = 0;
					MODdeltaX = 0;
					MapLoc.SetXY(0,0);
					Tile_Width = w;
					Tile_Height = h;
					LeftLocLimit = 0;
					RightLocLimit = Virtual_Width_Pix / Tile_Width;
					DisplayStart.SetXY(dsx, dsy);
					MapVirtualPort.Set(0,0,Virtual_Width_Pix,Virtual_Height_Pix);
				}

	void		SetMapDisplayPort(int sx, int sy, int ex, int ey) {
					MapDisplayPort.Set(sx,sy,ex,ey);
				}
	void		SetMapVirtualPort(int sx, int sy, int ex, int ey) {
					MapVirtualPort.Set(sx,sy,ex,ey);
				}

	// Create a new tile type, and then return a handle to it
	Tile_Handle	NewTile		(COLOR c);
	Tile_Handle	NewTile		(TBitmap *bmp);

	// Set a position on the tile map
	void		SetTile		(int x, int y, Tile_Handle th);

	void		Dirty		(TSprite *);
	void		DrawWholeMap(void);

	void		Move		(int dx);
	void		MoveLeft	(int dx);
	void		MoveRight	(int dx);
};

#endif