/* HSV.C, by Aaron A. Collins, based on code from */
/* Bow.c, by Marc R. Reinig - Based on code from */
/* Rainbow.c (C) 1989, Mark C. Peterson */

/* Will compile under MSC 6.0 or Turbo-C 2.0... */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <math.h>

#ifndef MK_FP
#define	MK_FP(seg,ofs)	((void far *)(((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#endif

struct Cones1
{
	long r, g, b;
};

struct Cones1 NaturalIntensity1(unsigned);
void SetColorGun1(unsigned, struct Cones1);
void convert_hsv_to_rgb(void);
void setvidmode(int);
void putpixel(int, int, unsigned char);
void line(int, int, int, int, unsigned char);

float hue, s, v;
long r2, g2, b2;

void main(void)
{
	unsigned WaveLength = 0;
	unsigned m, hu;
	struct Cones1 cone1;

	setvidmode(0x13); /* Engage VGA/MCGA 320x200 256 color mode (Ahhh!) */

	s=1.0; /* Initialize the saturation and Intensity to be High! */
	v=1.0;

	for (m = 1; m < 256; m++)
	{
		hue = 360.0 * ((float)(m))/256.0; /* normalize value to 360 */
		convert_hsv_to_rgb(); /* determine the values of r, g, b */
		cone1 = NaturalIntensity1(WaveLength); /* put rgb into cone */
		SetColorGun1(m, cone1); /* sets the palette to rgb value */
	/*      setcolor(m);	*/
		hu = (int) hue;
		if ((hu % 30) && m != 1) /* make longer line every 45 deg. */
			line(m+20, 70, m+20, 120, (unsigned char) m);
		else	line(m+20, 70, m+20, 130, (unsigned char) m);
	/*      moveto(m + 20, 70);	*/   /* Draws the rainbow */
	/*      lineto(m + 20, 120);	*/
	}

	while(kbhit())
		getch();
	getch();
	setvidmode(0x03);	/* Back to dull, boring text mode (*Yawn*) */
}

/* Conversion from Hue, Saturation, Value to Red, Green, and Blue */
/* From "Computer Graphics", Donald Hearn & M. Pauline Baker, pg.304 */

float       nr, ng, nb;          /* rgb values of 0.0 - 1.0      */

void convert_hsv_to_rgb()
{
        float p1, p2, p3, i, f;
        float xh;
        extern float hue,  s,  v;  /* hue (0.0 to 360.0, is circular, 0=360)
                                      s and v are from 0.0 - 1.0) */
        extern long  r2,  g2,  b2; /* values from 0 to 63 */

        if (hue == 360.0)
		hue = 0.0;           /* (THIS LOOKS BACKWARDS)       */

        xh = hue / 60.;                   /* convert hue to be in 0,6       */
        i = (float)floor((double)xh);    /* i = greatest integer <= h    */
        f = xh - i;                     /* f = fractional part of h     */
        p1 = v * (1 - s);
        p2 = v * (1 - (s * f));
        p3 = v * (1 - (s * (1 - f)));

        switch ((int) i)
	{
                case 0:
			nr = v;
			ng = p3;
			nb = p1;
			break;
                case 1:
			nr = p2;
			ng = v;
			nb = p1;
			break;
                case 2:
			nr = p1;
			ng = v;
			nb = p3;
			break;
                case 3:
			nr = p1;
			ng = p2;
			nb = v;
			break;
                case 4:
			nr = p3;
			ng = p1;
			nb = v;
			break;
                case 5:
			nr = v;
			ng = p1;
			nb = p2;
			break;
        }

        r2 = (long)(nr * 63.); /* Normalize the values to 63 */
        g2 = (long)(ng * 63.);
        b2 = (long)(nb * 63.);
        return;
}

struct Cones1 NaturalIntensity1(WaveLength)
unsigned WaveLength;
{
	struct Cones1 cone1;
	extern long r2, g2, b2;

	if (WaveLength)	/* to satisfy LINT... */
		;
	cone1.r = r2;
	cone1.g = g2;
	cone1.b = b2;
	return(cone1);
}

void SetColorGun1(Val, cone1)
unsigned Val;
struct Cones1 cone1;
{
	union REGS Regs;

	Regs.x.ax = 0x1010;	/* Set one pallette register function */
	Regs.x.bx = Val;	/* the pallette register to set (color #) */
	Regs.h.dh = (unsigned char)(cone1.r); /* gun values (6 bits ea.) */
	Regs.h.ch = (unsigned char)(cone1.g);
	Regs.h.cl = (unsigned char)(cone1.b);
	int86(0x10, &Regs, &Regs);	/* Do the video interrupt */
}

void setvidmode(mode)
int mode;
{
	union REGS inr, outr;

	inr.x.ax = 0x6f05;
	inr.x.bx = mode & 0x00ff;
	int86(0x10, &inr, &outr);
	inr.x.ax = 0x1000;
	inr.x.bx = 0;
	int86(0x10, &inr, &outr);
}

void putpixel(x, y, color)
int x, y;
unsigned char color;
{
	unsigned char far *fp;

	fp = MK_FP(0xa000, 320 * y + x);
	*fp = color;
}

void line(x1, y1, x2, y2, color)
int x1, y1, x2, y2;
unsigned char color;
{
	while (x1 != x2 || y1 != y2)
	{
		putpixel(x1, y1, color);
		if (x1 != x2)
			x1++;
		if (y1 != y2)
			y1++;
	}
}


