/*
 * bauble: a tiny room-based messaging system
 *
 * lock: person/system/tty locking.
 */
#include <fcntl.h>
#include "news.h"

extern char *basename();

/*
 * mklock() constructs a lockname
 */
static char *
mklock(thing)
char *thing;
{
    static char lockname[128];

#if ATARIST|MSDOS
    register len;

    sprintf(lockname, "%s\\%s", SPOOL, thing);
    len = strlen(lockname)-1;
    if (lockname[len] == ':')
	lockname[len] = ';';
    strcat(lockname, ".LCK");
#else
    sprintf(lockname, "%s\\%s", SPOOL, basename(thing));
#endif
    return lockname;
} /* mklock */


/*
 * lock() puts a lock on someone
 */
lock(thing)
char *thing;
{
    register char *lock = mklock(thing);
    register fd;

    if ((fd=open(lock, O_RDWR|O_EXCL|O_CREAT, S_IREAD|S_IWRITE)) >= 0) {
	close(fd);
	return 1;
    }
    return 0;
}


/*
 * unlock() lifts the lock on someone
 */
unlock(thing)
char *thing;
{
    unlink(mklock(thing));
}
