#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <time.h>

#define MAXINDEX 150
#define C1 50 
#define C2 10
#define C3 5

struct linerec
{
    int x1, x2, y1, y2, color;
};

struct linerec linearray[MAXINDEX];

int maxstore = 0;

void eraseline(int index)
{
    setcolor(0);
    line(linearray[index].x1, linearray[index].x2, 
	linearray[index].y1, linearray[index].y2);
}

int maxcolor;

void newcolor(int *color, int *count1)
{
    *color = random(maxcolor-1) + 1;
    *count1 = random(C1) + 1;
}

void newstep (int *dx1, int *dy1, int *dx2, int *dy2, int *count2)
{
    *dx1 = random(C2) - C3;
    *dx2 = random(C2) - C3;
    *dy1 = random(C2) - C3;
    *dy2 = random(C2) - C3;
    *count2 = random(C1) + 1;
}

void newcoord(int *n, int *change, int min, int max)
{
    int temp;

    temp = *n + *change;
    if (temp < min || temp > max) *change = -*change;
    else *n = temp;
}

int xmin = 0, ymin = 0, xmax, ymax;
int dy1, dy2, dx1, dx2;


void computenew(int *lx1, int *lx2, int *ly1, int *ly2)
{
    newcoord(lx1, &dx1, xmin, xmax);
    newcoord(ly1, &dy1, ymin, ymax);
    newcoord(lx2, &dx2, xmin, xmax);
    newcoord(ly2, &dy2, ymin, ymax);
}


void storedata(int xx1, int xx2, int yy1, int yy2, int color, int index)
{
    linearray[index].x1 = xx1;
    linearray[index].x2 = xx2;
    linearray[index].y1 = yy1;
    linearray[index].y2 = yy2;
    linearray[index].color = color;
    if (index > maxstore) maxstore = index;
}

int delay_time;

long timemark(void)
{
    struct time mytime;

    gettime(&mytime);

    return mytime.ti_min * 6000L + mytime.ti_hour * 360000L
	   + mytime.ti_sec * 100 + mytime.ti_hund;
}

void setspeed(void)
{
    int i;

    long time1, time2;


    time1 = timemark();

       
    for ( i = 0; i < 100; i++)
    {
	setcolor(1);
	line(xmin, ymin, xmax, ymax);
	setcolor(0);
	line(xmin, ymin, xmax, ymax);
    }
    
    time2 = timemark();

    if (time1 > time2) setspeed();
    else delay_time = 2000/(time2 - time1);
 
}

void main(void)
{
    int graphdriver = 0; /* IBM8514; for use with 8514 */
    int graphmode = 0; /* 1; */
    struct palettetype far *pal = NULL;
    int i, errorcode, erasing = 0, index = 0, color;
    int lx1, lx2, ly1, ly2, count1 = 0, count2 = 0;
    int ch;
    char far *ptr;


    char buff[100];

    randomize();

    registerbgidriver(CGA_driver);
    registerbgidriver(EGAVGA_driver);
    registerbgidriver(Herc_driver);
    registerbgidriver(ATT_driver);
    registerbgidriver(PC3270_driver);
    registerbgidriver(IBM8514_driver);


    initgraph(&graphdriver, &graphmode, NULL);


    errorcode = graphresult();

    if (errorcode != grOk)
    {
	puts("\nError: ");
	switch (errorcode)
	{
	    case grNotDetected :
		puts("Cannot detect a graphics card");
		break;

	    case grFileNotFound :
		puts("Cannot find driver file");
		break;

	    case grInvalidDriver :
		puts("Invalid Driver");
		break;

	    case grNoLoadMem :
		puts("Insufficient memory to load driver");
		break;
	}
	exit(1);
    }

    pal = getdefaultpalette();

    maxcolor =	pal->size;

    xmax = getmaxx();
    ymax = getmaxy();

    i = 1;
    outtextxy(0, i, ptr = "Welcome to LASERGRAPH!");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "Pressing the <ESC> key");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "will end the program.");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "Pressing the <Space> bar");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "will freeze the action.");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "Press any key to continue.");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "Press <+> to speed up.");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "Press <-> to slow down.");
    i += textheight(ptr);
    outtextxy(0, i, ptr = "Press <C> to clear the screen.");
    i += textheight(ptr);

    outtextxy(0, i, ptr = "To begin the show press any key...");
/*
    sprintf(buff, "maxx is %d, maxy is %d, mode is %d", xmax, ymax, graphdriver);
    i += 10;
    outtextxy(0, i, buff);
*/

    getch();
    cleardevice();

    setspeed();

    cleardevice();

    lx2 = lx1 = xmin;
    ly1 = ly2 = ymin;


    do
    {
	ch = 0;
	if (index >= MAXINDEX-1)
	{
	    index = 0;
	    erasing = 1;
	}

 	if (erasing) eraseline(index);

	if (count1 == 0) newcolor(&color, &count1);

        if (count2 == 0) newstep(&dx1, &dy1, &dx2, &dy2, &count2);

	count1--;
	count2--;

	computenew(&lx1, &lx2, &ly1, &ly2);
	setcolor(color);
	line(lx1, lx2, ly1, ly2);
       
	storedata(lx1, lx2, ly1, ly2, color, index++);

	while (kbhit()) ch = getch();
	{
            switch (ch)
            {
                case ' ' : 
		    ch = getch();
		    break;
		
		case '+' : 
		    if (delay_time > 0) delay_time--;
		    break;
		
		case '-' :
		    if (delay_time < 100) delay_time++;
		    break;

		case 'c' :
		case 'C' :
		    cleardevice();
		    erasing = 0;
		    index = 0;
		    break;

	    }
	}
	
	delay(delay_time);
    }
    while (ch != 27);

    closegraph();

}