/* LISTGIF - scans through all GIF files and reports size and colors */

#define INCL_DOSFILEMGR

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

void gif_stat(FILEFINDBUF *filespec);
unsigned int getbytes(FILE *dev);

void main(int argc, char *argv[])
{
    int           i,
                  count = 1;
    FILEFINDBUF   filespec;
    char          filename[90];
    HDIR          filespec_handle = HDIR_SYSTEM;

    strcpy(filename, "*.GIF");
    if (--argc)
   {
      strcpy(filename, argv[1]);
   }

    if (DosFindFirst(filename, &filespec_handle, FILE_NORMAL, &filespec,
               sizeof(filespec), &count, 0L) != 0)
       {
       printf("No GIFs here...\n");
       return;
       }
    else
       {
       gif_stat(&filespec);

       while (DosFindNext( filespec_handle, &filespec, sizeof(filespec), &count) == 0)
          gif_stat(&filespec);

       DosFindClose(filespec_handle);
       }

}


/* GIF_STAT - the main routine reads and displays the GIF info. */
void gif_stat(FILEFINDBUF *filespec)
{
    char version[7];
    int byte1, byte2 ,byte3;
    int color_res, colors;
    int bits_per_pix, bits_to_use;
    int i;
    unsigned int width;
    unsigned int height;
    char filenm[9];
    FILE *infile;
    int  hours,
         minutes,
         year,
         month,
         day;
    char ampm;


    /* Check for GIF filename */

     if ((infile = fopen (filespec->achName, "rb")) == NULL)
       return;

     /* trim the ".GIF" off of the filename, for display purposes */
     filespec->achName[strlen(filespec->achName)-4] = '\0';
     printf("   %-8s  %3s  %8ld  ", filespec->achName, "GIF", filespec->cbFile);


    /* pick out the various elements of the file's date and time */
     year    = ((filespec->fdateLastWrite.year )   & 0x7F) + 80;
	  month   =  (filespec->fdateLastWrite.month)   & 0x0F;
	  day     =   filespec->fdateLastWrite.day      & 0x1F;
	  hours   =  (filespec->ftimeLastWrite.hours)   & 0x1F;
	  minutes =  (filespec->ftimeLastWrite.minutes) & 0x3F;

     if (hours > 12)
     {
         hours = hours - 12;
         ampm  = 'p';
     }
     else
         ampm  = 'a';
         
     printf("%2d-%02d-%02d", month, day, year);
     printf("  %02d:%02d%c", hours, minutes, ampm);

    /* get version from file - no version = no picture */
    if ((version[0] = getc(infile)) == 0x47) {
      for (i = 1; (i < 6); i++)
        version[i] = getc(infile);
      version[6] = '\0';

      /* find picture width */
      width = getbytes(infile);

      /* find picture height */
      height = getbytes(infile);

      /* skip bytes for a Global Map */
      byte1 = getc(infile);
      byte2 = byte1 & 0x80;

      /* determine the color resolution */
      byte2 = byte1 & 0x70;
      color_res = byte2 >> 4;

      /* get the background index */
      byte3 = getc(infile);

      /* determine the bits per pixel */
      bits_per_pix = byte1 & 0x07;
      bits_per_pix++;
      bits_to_use = bits_per_pix;

      /* determine # of colors in global map */
      colors = 1 << bits_per_pix;

      /* display the GIF information */
      printf(" - [");
      printf("%3d", width);
      printf("x");
      printf("%3d", height);
      printf("x");
      printf("%3d", colors);
      printf("]\n");
    }
    else
      printf(" - NOT A GIF FILE\n");

    fclose(infile);
}

/* GETBYTES - routine to retrieve two bytes of information from the GIF */
/*            file and then shift them into correct byte order.  The    */
/*            information is stored in Least Significant Byte order.    */

unsigned int getbytes(FILE *dev)
{
    int byte1;
    int byte2;
    int result;

    /* read bytes and shift over */
    byte1 = getc(dev);
    byte2 = getc(dev);

    result = (byte2 << 8) | byte1;
    return result;
}
