;
; Original idea (pascal) : Bjarke Viksoe
; Translated/Modified by : Edward C Willemsen of ExEd!
;
	SMART
        .MODEL Small, Pascal
        Locals
        Jumps

        assume  cs:@CODE,ds:@DATA

        .DATA

xtable	Label	Word
	include	xtab.inc
ytable	Label	Word
	include	ytab.inc



        .CODE

;
; Set the color palette, the first 128 only :
;
SetZPal	PROC
	LOCAL	colval:BYTE
	mov     ax,@DATA
	mov     ds,ax
	mov	dx,3c8h
	xor	al,al
	out	dx,al
	inc	dx
	
	mov	colval,0
	
	mov	cx,63
@@StNxt:
	mov	al,colval
	out	dx,al
	xor	al,al
	out	dx,al
	mov	al,colval
	out	dx,al
	inc	colval
	loop	@@StNxt

	out	dx,al
	xor	al,al
	out	dx,al
	mov	al,colval
	out	dx,al

	mov	cx,64
@@StNxt2:
	mov	al,colval
	out	dx,al
	xor	al,al
	out	dx,al
	mov	al,colval
	out	dx,al
	dec	colval
	inc	cx
	cmp	cx,127
	jbe	@@StNxt2
	ret
SetZPal	ENDP

;
; Generate and show the generated pattern :
;
MakePattern	PROC
	ARG	value:BYTE
	LOCAL	ytaller:WORD
	mov	ax,@DATA
	mov	ds,ax
	mov	ytaller,200
	mov     ax,0A000h
	mov     es,ax
	xor     di,di

	mov     cl,value
	mov	ch,127
@@yloop:
	mov     dl,160
	lea     si,xtable
@@xloop1:
	mov     bx,WORD PTR ytable
	add     bx,[si]
	mov     ax,bx
	shr     ax,cl
	and     al,ch
	stosb
	add     si,2
@@xloop2:
	mov     bx,WORD PTR ytable
	add     bx,[si]
	mov     ax,bx
	shr     ax,cl
	and     al,ch
	stosb
	add	si,2
	dec     dl
	jnz     @@xloop1

	add     WORD PTR @@xloop1+2,2
	add     WORD PTR @@xloop2+2,2
	dec     ytaller
	jnz     @@yloop

	lea     di,ytable
	mov     WORD PTR @@xloop1+2,di
	mov     WORD PTR @@xloop2+2,di
	ret
MakePattern	ENDP

;
; The MAIN part :
;
Start:	mov	ax,@DATA
	mov	ds,ax
	mov	ax,13h
	int	10h
	
	cld
	call	SetZPal

@@MnLp:	mov	cx,16
@@MnLpB:
	push	cx
	call	MakePattern, cx
	pop	cx
	dec	cx
	cmp	cx,1
	ja	@@MnLpB
	
	mov	cx,1
@@MnLpC:
	push	cx
	call	MakePattern, cx
	pop	cx
	inc	cx
	cmp	cx,15
	jb	@@MnLpC

	mov	ah,1
	int	16h
	jz	@@MnLp
	
	mov	ah,0
	int	16h

@@done:	mov	ax,3h
	int	10h
	mov	ax,4c00h
	int	21h
	
	end	Start