PROGRAM PCX_VIEW;

{ This program displays PCX graphic picture files in either 2, 4, 16 or 256
  colors on either a CGA, EGA, MCGA or VGA graphics card. }

USES
  Dos, OpString, OpCrt, OpRoot, OpCmd, OpFrame, OpWindow, OpPick, OpDir, showpcx;

  {Color set used by Directory "menu"}
CONST
  MenuColors : ColorSet = (
    TextColor : $4E {YellowOnRed} ; TextMono : $07 {LtGrayOnBlack} ;
    CtrlColor : $1E {YellowOnBlue} ; CtrlMono : $0F {WhiteOnBlack} ;
    FrameColor : $4A {LtGreenOnRed} ; FrameMono : $07 {LtGrayOnBlack} ;
    HeaderColor : $4F {WhiteOnRed} ; HeaderMono : $70 {BlackOnLtGray} ;
    ShadowColor : $00 {BlackOnBlack} ; ShadowMono : $0F {WhiteOnBlack} ;
    HighlightColor : $4F {WhiteOnRed} ; HighlightMono : $70 {BlackOnLtGray} ;
    PromptColor : $30 {BlackOnCyan} ; PromptMono : $07 {LtGrayOnBlack} ;
    SelPromptColor : $30 {BlackOnCyan} ; SelPromptMono : $07 {LtGrayOnBlack} ;
    ProPromptColor : $30 {BlackOnCyan} ; ProPromptMono : $07 {LtGrayOnBlack} ;
    FieldColor : $1E {YellowOnBlue} ; FieldMono : $07 {LtGrayOnBlack} ;
    SelFieldColor : $31 {BlueOnCyan} ; SelFieldMono : $0F {WhiteOnBlack} ;
    ProFieldColor : $17 {LtGrayOnBlue} ; ProFieldMono : $07 {LtGrayOnBlack} ;
    ScrollBarColor : $13 {CyanOnBlue} ; ScrollBarMono : $07 {LtGrayOnBlack} ;
    SliderColor : $13 {CyanOnBlue} ; SliderMono : $0F {WhiteOnBlack} ;
    HotSpotColor : $30 {BlackOnCyan} ; HotSpotMono : $70 {BlackOnLtGray} ;
    BlockColor : $3E {YellowOnCyan} ; BlockMono : $0F {WhiteOnBlack} ;
    MarkerColor : $5F {WhiteOnMagenta} ; MarkerMono : $70 {BlackOnLtGray} ;
    DelimColor : $31 {BlueOnCyan} ; DelimMono : $0F {WhiteOnBlack} ;
    SelDelimColor : $31 {BlueOnCyan} ; SelDelimMono : $0F {WhiteOnBlack} ;
    ProDelimColor : $31 {BlueOnCyan} ; ProDelimMono : $0F {WhiteOnBlack} ;
    SelItemColor : $7A {LtGreenOnLtGray} ; SelItemMono : $70 {BlackOnLtGray} ;
    ProItemColor : $47 {LtGrayOnRed} ; ProItemMono : $07 {LtGrayOnBlack} ;
    HighItemColor : $4F {WhiteOnRed} ; HighItemMono : $0F {WhiteOnBlack} ;
    AltItemColor : $4F {WhiteOnRed} ; AltItemMono : $0F {WhiteOnBlack} ;
    AltSelItemColor : $3F {WhiteOnCyan} ; AltSelItemMono : $70 {BlackOnLtGray} ;
    FlexAHelpColor : $4F {WhiteOnRed} ; FlexAHelpMono : $0F {WhiteOnBlack} ;
    FlexBHelpColor : $4F {WhiteOnRed} ; FlexBHelpMono : $0F {WhiteOnBlack} ;
    FlexCHelpColor : $1B {LtCyanOnBlue} ; FlexCHelpMono : $70 {BlackOnLtGray} ;
    UnselXrefColor : $1E {YellowOnBlue} ; UnselXrefMono : $09 {LtBlueOnBlack} ;
    SelXrefColor : $5F {WhiteOnMagenta} ; SelXrefMono : $70 {BlackOnLtGray} ;
    MouseColor : $4F {WhiteOnRed} ; MouseMono : $70 {BlackOnLtGray}
    );

VAR
  Dir : DirList;
  Finished : Boolean;
BEGIN
  TextMode(co80);                 { start in 25 x 80 text mode }

  IF NOT Dir.InitCustom(25, 5, 55, 20, {Window coordinates}
                        MenuColors, {ColorSet}
                        DefWindowOptions OR wBordered, {Window options}
                        MaxAvail, {Heap space for files}
                        PickVertical, {Pick orientation}
                        SingleFile) {Command handler}
  THEN BEGIN
    WriteLn('Failed to Init DirList,  Status = ', InitStatus);
    Halt;
  END;
  {Set desired DirList features}
  Dir.SetPosLimits(1, 1, ScreenWidth, ScreenHeight-1);
  Dir.SetPadSize(1, 1);
  Dir.diOptionsOn(diOptimizeSize);
  Dir.AddMaskHeader(True, 1, 30, heTC);
  Dir.SetSortOrder(SortName);
  Dir.SetNameSizeTimeFormat('<dir>', 'Mm/dd/yy', 'Hh:mmt');
  Dir.SetMask('*.PCX', AnyFile);
  {Pick a file}
  Finished := False;
  REPEAT
    Dir.Process;
    CASE Dir.GetLastCommand OF
      ccSelect :
        BEGIN
          ShowPicture(Dir.GetSelectedPath);
          Dir.wFrame.Draw;
        END;
      ccError :
        BEGIN                     {!!.01}
          FastWrite('Error '+Long2Str(Dir.GetLastError),
                    ScreenHeight, 1, TextAttr);
          Finished := True;       {!!.01}
        END;                      {!!.01}
      ccQuit :
        Finished := True;
      {Process other exit commands}
    END;
  UNTIL Finished;
  Dir.Done;

END.
