/* INIT.C : Initialization code for reading settings from SSTOOLS.INI.
*/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "piclab.h"

const char	ifname[] = "SSTOOLS.INI",
			toolname[] = "PICLAB";

static void initline(char *line)
{
	int argc;
	argument argv[3];
	char *cp;

	argv[1].cval = line;
	if ((cp = strchr(line, '=')) == NULL) argc = 2;
	else {
		argc = 3;
		*cp = '\0';
		argv[2].cval = ++cp;
		argv[2].fval = (float)atof(cp);
	}
	setvar(argc, argv);
}

int initfile()
{
	U32 mem;
	char *path, c, *cp, str[90];
	int oursection = 1, len, ifile;
	U8 *buf;

	mem = mark();
	if ((buf = talloc(BUFSIZE+80)) == NULL) return 2;

	if ((path = getenv("INIT")) == NULL) {				/* Search INIT or */
		if ((path = getenv("PATH")) == NULL) path = "";	/* PATH, not both */
	}

	strcpy(str, ifname);	/* Try current directory first */
	while (1) {
		if ((ifile = p_open(str, buf, BUFSIZE, 80, READ)) < 0) {
			if (*path == '\0') return 0;		/* No initfile found */
			else {
				cp = str;
				while (*path && *path != ';') *cp++ = *path++;
				if (*path == ';') ++path;

				if ((c = *(cp-1)) != '\\' && c != '/' && c != ':')
					*cp++ = '\\';				/* Ensure path ends with \ */
				strcpy(cp, ifname);
				continue;						/* Try next directory */
			}
		}

		while (p_gets(str, 80, ifile) != NULL) {
			len = strlen(cp = str);
			while (len > 0 && isspace(cp[len-1]))
				cp[--len] = '\0';				/* Strip trailing blanks */
			while (len > 0 && isspace(*cp)) ++cp;	/* And leading blanks */

			if (len == 0) continue;				/* Skip blank lines */
			if (*cp == ';') continue;			/* And comments */
			strupr(cp);							/* Fold case */

			if (*cp == '[') {					/* Section header */
				oursection =
					(strncmp(cp+1, toolname, strlen(toolname)) == 0);
				continue;						/* Always skip header	*/
			}
			if (oursection) initline(cp);
		}
		p_close(ifile);
		break;									/* File found and done	*/
	}
	release(mem);
	return 1;
}
