/* PLPRINTF.C
*/

#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <memory.h>
#include <stdarg.h>
#include <dos.h>

#include "piclab.h"

typedef char *charptr;
typedef void (*pfunc)(void *, char *, int);

static int ltos(long val, char *cp, int base)
{
    char tempc[34], *tcp;
    int n;
    long uval;
    static char dig[]={"0123456789ABCDEF"};

    *(tcp=tempc+33) = (char)(n = 0);

    if (base < 0) {
        if (val < 0) n = 1; else val = -val;
        do {
            *--tcp = dig[-(val % base)];
        } while (val /= -base);
    } else {
        uval = val;
        do {
            *--tcp = dig[uval % base];
        } while (uval /= base);
    }
    if (n) *--tcp = '-';
    n = tempc+33-tcp;
	memcpy(cp, tcp, n+1);
    return n;
}

static int _fmtout(pfunc func, void *funarg, char *str, va_list args)
{
    char tbuf[128], *cp;
    int base, padchar, width, length, prec;
    int is_num, precflg, longflg, leftadj;
    long lw;

    while (*str) {
        if (*str != '%') {
            for (cp = str; *++cp && *cp != '%'; )
                ;
            if (cp != str) (*func)(funarg, str, cp-str);
            str = cp;
        } else {
            is_num = 1;
            if (leftadj = (*++str == '-')) ++str;
            if ((padchar = *str) == '0') ++str; else padchar = ' ';
            if (*str == '*') {
                width = va_arg(args, int);
                ++str;
            } else
            for (width = 0; isdigit(*str); )
                width = width * 10 + (*str++ - '0');
            if (precflg = (*str == '.')) {
                ++str;
                if (*str == '*') {
                    prec = va_arg(args, int);
                    ++str;
                } else
                for (prec = 0; isdigit(*str); )
                    prec = prec * 10 + (*str++ - '0');
            } else prec = 0;
            if (longflg = (tolower(*str) == 'l')) ++str;

            switch (*str) {
	            case 'B':
    	        case 'b':
        	        base = 2;
            	    goto nosign;
	            case 'O':
    	        case 'o':
        	        base = 8;
            	    goto nosign;
	            case 'U':
    	        case 'u':
        	        base = 10;
            	    goto nosign;
	            case 'X':
    	        case 'x':
        	        base = 16;
            	    goto nosign;
	            case 'D':
    	        case 'd':
        	        base = -10;
nosign:
	                if (!longflg) longflg = (isupper(*str));
    	            if (longflg) lw = va_arg(args, long);
	                else if (base<0) lw = (long)(va_arg(args, int));
    	            else lw = va_arg(args, unsigned);

        	        ltos (lw, tbuf, base);
            	    if (precflg) {
                	    cp = tbuf;
                    	if (lw < 0) ++cp;
	                    length = strlen(cp);
    	                if (prec && length < prec+1) {
							memcpy(cp+prec+1-length, cp, length+1);
							memset(cp, 0, prec+1-length);
                	        length = prec+1;
                    	}
						memcpy(cp+length-prec+1, cp+length-prec, prec+1);
    	                cp[length-prec] = '.';
        	        }
            	    length = strlen(cp = tbuf);
                	break;
	            case 's':
    	            cp = va_arg(args, charptr);
        	        length = strlen(cp);
            	    if (precflg && prec < length) length = prec;
	                goto char2;
	            case 'c':
    	            cp = &va_arg(args, char);
        	        goto char1;
            	default:
                	cp = str;
char1:
	                length = 1;
char2:
	                is_num = 0;
    	            break;
        	}
            if (!leftadj && width > length) {
                if (is_num && *cp == '-' && padchar == '0') {
                    (*func)(funarg, cp++, 1);
                    --length;
                    --width;
                }
                while (width-- > length) (*func)(funarg, (char *)&padchar, 1);
            }
            if (width > length) width -= length; else width = 0;
            if (length) (*func)(funarg, cp, length);
            if (leftadj && width)
                while (width--) (*func)(funarg, space, 1);
            ++str;
        }
    }
	va_end(args);
   return(0);
}

static void _store(char **to, char *from, int len)
{
	memcpy(*to, from, len);
	*to += len;
	**to = '\0';
}

static void _print(void *nil, char *from, int len)
{
	unsigned bw;
	_dos_write(1, from, len, &bw);
}

int pl_sprintf(char *str, char *cont, ...)
{
	va_list args;

	va_start(args, cont);
    return _fmtout(_store, (void *)&str, cont, args);
}

int pl_printf(char *cont, ...)
{
	va_list args;

	if (!interactive) return 0;
	va_start(args, cont);
	return _fmtout(_print, NULL, cont, args);
}
