{$A+,B-,D-,E-,F-,G+,I+,L-,N-,O-,R-,S-,V-,X-}
{$M 1024,0,0}
program plasma;

(* Plasma by Mr.Patcher, aka Holger Daehre 2:2465/317.88
   released 16/02/94
   requires 386 cpu, 486 is recommended.
*)

var
   source,count,plasma_seg,move_seg,color_seg:word;
   datf:file;
   i:byte;

function malloc(amount:word):word;assembler;
asm
  mov     ah,48h
  mov     bx,amount
  int     21h
  jnc     @malloc_ok
  mov     ax,0ffffh
@malloc_ok:
end;

procedure mfree(where:word);assembler;
asm
 mov     ah,49h
 mov     es,where
 int     21h
end;

procedure memerr;
begin
  writeln(#254+'Error: could''nt not allocate memory - aborting');
  halt(255)
end;

begin
 plasma_seg:=malloc(9600+1); 
 if plasma_seg=$ffff then memerr;
 move_seg:=malloc(2500+1); 
 if move_seg=$ffff then memerr;
 color_seg:=malloc(1920+1); 
 if color_seg=$ffff then memerr;
 assign(datf,'PLASMA.DAT');
 {$I-}
 reset(datf,1);
 {$I+}
 if IOresult <> 0 then
 begin
  writeln(#254+'Error: could''nt not open PLASMA.DAT - aborting');
  halt(255)
 end;
 for i:= 0 to 3 do blockread(datf,mem[plasma_seg+(i*$960):0],$9600);
 blockread(datf,mem[move_seg:0],40000);
 blockread(datf,mem[color_seg:0],30720);
 asm
  mov     ax,13h
  int     10h
 end;
 count:=0;
 repeat
  Repeat Until (Port[$3DA] And $08) = 0;
  Repeat Until (Port[$3DA] And $08) <> 0;
  source:=count*word(3);
  port[$3c8]:=1;
  for i:=1 to 255 do
  begin
   port[$3c9]:=mem[color_seg:source+3*i];
   port[$3c9]:=mem[color_seg:source+3*i+1];
   port[$3c9]:=mem[color_seg:source+3*i+2];
  end;
  asm
   mov ax,0a000h
   mov     es,ax
   mov     di,[count]
   shl     di,2
   push    ds
   mov     ds,[move_seg]
   mov     si,[di]
   mov     bx,[di+2]
   pop     ds
   push    ds
   mov     ds,[plasma_seg]
   xor     di,di
   mov     ch,200
@pl1:
   mov     cl,80
@pl2:
   db      66h
   lodsw
   db 66h
   add     ax,[si+bx]
   db 66h
   stosw
   dec     cl
   jnz     @pl2
   sub     si,320
   mov     dx,ds
   add     dx,32
   mov     ds,dx
   dec     ch
   jnz     @pl1
   pop     ds
  end;
  inc(count);
  if count=10000 then count:=0;
 until port[$60]=1;
 mfree(color_seg);
 mfree(move_seg);
 mfree(plasma_seg);
 asm
  mov     ax,3h
  int     10h
 end;
end.