/* seepcxhd.c                   31 oct 1990

  - seepcxhd displays a pcx file header
  - this is a first version, it could probably use some improvement
  - in particular, values it prints for Palette info, Hscreensize,
    and Vscreensize are suspect
  - written by Art D'Adamo, CompuServe 72371,1673
  - complied using QuickC 2.5
  - released into the public domain

*/

#define HDR_LEN 128

static int load_int( char a[] ), pause_ec( int a );

#include <stdio.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <conio.h>

char buf[1000], ibuf[2];
char red[256], green[256], blue[256];
int version;
union {
    char a;
    unsigned int b;
} x;
unsigned int ir, ig, ib;
long flen, pos, offset;


/* ------------------------------------------------------------- */
main( argc, argv )
int argc;
char *argv[];
{
int i, k, fh, color, egavga;

    /* check input */
    if( argc < 2 ) {
	printf("\tUsage:    seepcxhd (PCX_image_file_name)");
	printf("\n\tExample:  seepcxhd abc.pcx");
	exit( 1 );
    }


    /* get the PCX file size */
    if( (fh = open( argv[1], O_RDONLY | O_BINARY)) != -1 ) {
	flen = filelength( fh );
	printf("PCX image file %s is %ld bytes long ", argv[1], flen );
    }
    else {
	printf("\nseepcxhd can't open %s. Must exit.", argv[1] );
	exit(1);
    }

    /* read PCX header */
    i = read (fh, buf, HDR_LEN);
    if (i != HDR_LEN ) {
	printf ("\n(image header) i %d, HDR_LEN %d", i, HDR_LEN);
	printf ("\nread error");
	exit( 1 );
    }

    /* show PCX header ------------------------------------------- */
    printf("\n%hd\tManufacturer code", buf[0]);

    version = (int) buf[1];
    printf("\n %hd\tVersion", version);
    if( version == 0 )
	printf(" - Version 2.5 of PC Paintbrush");
    else if( version == 2 )
	printf(" - Version 2.8 w/palette info");
    else if( version == 3 )
	printf(" - Version 2.8 w/o palette info");
    else if( version == 4 )
	printf(" - PC Paintbrush for Windows & Windows Ver 5");
    else if( version == 5 )
	printf(" - Win Ver 3.0 & Paintbrush & Publisher's PB");
    else printf(" - Unknown Version");

    i = (int) buf[2];
    printf("\n %hd\tEncoding", i);
    if( i == 0 ) printf(" - No Encoding");
    else if( i == 1 ) printf(" - .PCX run length encoding");
    else printf(" - Unknown Encoding");

    i = (int) buf[3];
    printf("\n %hd\tBits per Pixel per Plane", i);

    i = load_int( &(buf[4]) );   printf("\nWindow:\txmin: %3hd", i);
    i = load_int( &(buf[6]) );   printf("\tymin: %3hd", i);
    i = load_int( &(buf[8]) );   printf("\n\txmax: %3hd", i);
    i = load_int( &(buf[10]) );  printf("\tymax: %3hd", i);

    i = load_int( &(buf[12]) );
    printf("\n %hd\tHor. Res. in DPI", i);

    i = load_int( &(buf[14]) );
    printf("\n %hd\tVer. Res. in DPI", i);

    /* read & save EGA color map */
    i = 16;
    for( color = 0; color < 16; color++) {
	red[color] = buf[i++];
	green[color] = buf[i++];
	blue[color] = buf[i++];
    }

    printf("\n %hd\tNPlanes", buf[65] );

    i = load_int( &(buf[66]) );
    printf("\n %hd\tBytes per Line", i);

    i = load_int( &(buf[68]) );
    printf("\n %hd\tPalette info", i);

    i = load_int( &(buf[70]) );
    printf("\n %hd\tHscreensize", i);

    i = load_int( &(buf[72]) );
    printf("\n %hd\tVscreensize", i);


    /* Determine if EGA or VGA color map */
    offset = (long) flen-769;
    pos = lseek( fh, offset, SEEK_SET );
    if( pos == -1L ) {
	perror( "\nlseek failed" );
	printf("\nflen %d, offset %ld, pos %ld", flen, offset, pos);
	exit( 1 );
    }
    i = read (fh, buf, 769);
    if (i != 769 ) {
	printf ("\nread error (769), i %d", i);
	exit( 1 );
    }
    egavga = buf[0];

    /* print out color map? */
    if( egavga != 12 ) printf("\n\nShow EGA color map? (y/n) > ");
    else printf("\n\nShow VGA color map? (y/n) > ");
    i = getche();
    if( i != 'y' && i != 'Y') return 0;

    /* print out color map */
    if( egavga != 12 ) {
	/* print EGA color map */
	printf("\n\n\tEGA Color Map\nColor\t  Red\tGreen\t Blue");
	for( color = 0; color < 16; color++) {
	    x.a = red[color];   ir = x.b;
	    x.a = green[color];   ig = x.b;
	    x.a = blue[color];   ib = x.b;
	    printf("\n  %u\t  %d\t  %u\t  %u", color, ir, ig, ib);
	}
    }
    else {
	/* print VGA color map */
	printf("\n\n\t\tVGA Color Map\t(Color, Red, Green, Blue)");
	i = 1;
	for( color = 0; color < 256; color +=4) {
	    x.a = buf[i++];   ir = x.b;
	    x.a = buf[i++];   ig = x.b;
	    x.a = buf[i++];   ib = x.b;
	    printf("\n(%3u,%3u,%3u,%3u)", color, ir, ig, ib);
	    x.a = buf[i++];   ir = x.b;
	    x.a = buf[i++];   ig = x.b;
	    x.a = buf[i++];   ib = x.b;
	    printf("  (%3u,%3u,%3u,%3u)", color+1, ir, ig, ib);
	    x.a = buf[i++];   ir = x.b;
	    x.a = buf[i++];   ig = x.b;
	    x.a = buf[i++];   ib = x.b;
	    printf("  (%3u,%3u,%3u,%3u)", color+2, ir, ig, ib);
	    x.a = buf[i++];   ir = x.b;
	    x.a = buf[i++];   ig = x.b;
	    x.a = buf[i++];   ib = x.b;
	    printf("  (%3u,%3u,%3u,%3u)", color+3, ir, ig, ib);
	    if( color > 0 && color%88 == 0 ) pause_ec( 1 );
	}
    }

    close( fh );
    return 0;
}


/* -------------------------------------------------- */
static int load_int( cbuf )
char cbuf[];
{
    union {
	int       s_int;
	char            s_chr[2];
    } s_un;

    s_un.s_chr[0] = cbuf[0];
    s_un.s_chr[1] = cbuf[1];
    return s_un.s_int;

}

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
static int pause_ec( int flag )
{
int ch;
fflush( stdin );
if( flag > 0 ) printf("\n\tPress any key to continue > ");
ch = getch();
return 0;
}

