
;
; Some graphical string procedures handy for demo programming (perhaps).
;
; Edward C Willemsen,
; Exed-software, 1994.
;

	SMART
	.MODEL Small,pascal
	.STACK 200h
	assume cs:@CODE,ds:@DATA
	Jumps

FONTW	equ	16
FONTH	equ	30
MAXX	equ	320
MAXY	equ	200
SDEPTH	equ	110	; Y position of scroller.

	.DATA
Font	Label Byte
	include	Font.Db
Pal	Label Byte
	include Font.Pal

TextPnt	dw	0
ScrnPnt	dw	0
TextSpd	db	0		; 0 for slow charakter draw, 1 for fast draw

String	db	'EXED IS VERY COOL [ ',13,13
	db	'AND WHEN I SAY COOL ',13,13,13
	db	' I MEAN COOOOOOL [',0

Scroll	db	'JUST A SIMPLE SCROLL^^^^^^^^^^^^^^        '
	db	'SIMPLE TO MODIFICATE^^^^^^^^^^^^^^        '
	db	'EASY TO UNDERSTAND [                      ',0

Space	db	'ppppppppppppppppppp',0

Done	db	'SO CREDIT EXED [[[[[',13
	db	'      ALWAYS',0

FnkMss1	db	'THIS SOURCE CONTAINS',13
	db	'FOLLOWING PROCEDURES',13,13
	db	'PUT STRING          ',13
	db	'SLOW SHIFT LEFT     ',13
	db	'SLOW SHIFT RIGHT',0

FnkMss2	db	'FAST SHIFT LEFT     ',13
	db	'FAST SHIFT RIGHT    ',13,13
	db	'DAMASTo CLEARS THE  ',13
	db	'SCREEN^',0

FnkMss3	db	'SCROLL PUT STRING^  ',13,13
	db	'A TEXT SCROLLERo    ',13
	db	'ALL IN INT `bH GFX  ',13
	db	'MODE^',0

EndMess	db	' WELLo I THINK YOU  ',13
	db	' CAN USE THIS^      ',13
	db	' AND REMEMBER DO NOT',13
	db	' FORGET TO CREDIT   ',13
	db	' EXED [[[',0

	.CODE
Start:	mov	ax,@DATA
	mov	ds,ax
	mov	ax,13h
	int	10h
	call	set_pal
	call	put_str, MAXX*4+2, offset Font, offset String
	call	spt_str, MAXX*SDEPTH+316, offset Font, offset Scroll
	
	mov	cx,MAXX
scrlA:	push	cx
	call	lssLO, MAXX*65
	call	vstate
	pop	cx
	loop	scrlA

	call	put_str, MAXX*156, offset Font, offset Space
	call	put_str, MAXX*50, offset Font, offset Done

	mov	cx,MAXX/2
scrlB:	push	cx
	call	rssHI, MAXX*4
	call	vstate
	pop	cx
	loop	scrlB
	
	call	damast
	mov	cx,40
	call	delay

	mov	ax,@DATA
	mov	ds,ax
	mov	[TextSpd],1

	call	put_str, 0, offset Font, offset FnkMss1
	mov	cx,1000
	call	delay
	call	damast

	call	put_str, 0, offset Font, offset FnkMss2
	mov	cx,1000
	call	delay
	call	damast
	
	call	put_str, 0, offset Font, offset FnkMss3
	mov	cx,1000
	call	delay
	call	damast

	call	put_str, MAXX*20, offset Font, offset EndMess
	mov	cx,1000
	call	delay

	call	damast
	mov	cx,60
	call	delay

	mov	ax,3
	int	10h
	mov	ax,4c00h
	int	21h

;
; The most easy way to set the color palette :
;
set_pal	PROC
	mov	ax,@DATA
	mov	es,ax
	mov	ah,10h
	mov	al,12h
	flipflag	bx,bx
	mov	cx,256
	mov	dx,offset pal
	int	10h
	ret
set_pal	ENDP

;
; put_str : Outputs a text string with grafical charakters.
; The string ends with a 0.
; Use : call put_str y-position,offset FontData, offset String
;
put_str	PROC	near
	ARG	YPosition:WORD,FontOff:WORD,StringOff:WORD
	mov	ax,@DATA
	mov	ds,ax
	mov	[TextPnt],0
	mov	ax,YPosition
	mov	[ScrnPnt],ax
dotxt:	mov	ax,StringOff
	add	ax,[TextPnt]
	mov	si,ax
	flipflag	bx,bx
	mov	byte ptr bl,[si]
	cmp	bl,0
	je	txtdn
	call	put_chr, FontOff
	inc	[TextPnt]
	jmp	dotxt
txtdn:	ret
put_str	ENDP

;
; Subroutine used by put_str.
; Output a single charakter. The charakter is stored in BX ( BL ).
; Features : BX = 13 -> new line ( DI,SI += 320 )
;            BX = 32 -> space ( DI,SI += FONTW )
;
put_chr	PROC	near
	ARG	FontOff:WORD
	mov	ax,@DATA		; Font address
	mov	ds,ax
	mov	ax,0a000h		; Screen address
	mov	es,ax
	mov	si,FontOff
	mov	di,[ScrnPnt]		; Screen spot
	cld

	cmp	bx,13			; new line
	jne	noNl
	add	di,320*FONTH+1
	mov	[ScrnPnt],di
	jmp	charDn
noNl:
	cmp	bx,' '			; space
	jne	noSpc
	add	di,FONTW
	mov	[ScrnPnt],di
	jmp	charDn
noSpc:
	cmp	bx,'U'			; Vertical panning
	jb	skpChrA
	add	si,320*FONTH
skpChrA:
	cmp	bx,'h'			; Vertical panning
	jb	skpChrB
	add	si,320*FONTH
skpChrB:
	sub	bx,'A'			; Horizontal panning
	mov	ax,FONTW
	mul	bx
	add	si,ax

	mov	cx,FONTH
fntlpB:	push	cx
	mov	cx,FONTW/2
	repz	movsw
	add	si,MAXX-(FONTW)
	add	di,MAXX-(FONTW)
	; Skipped for fast output
	cmp	[TextSpd],1
	je	FastPut
	mov	dx,3dah
WVRT:	in	al,dx		; port 3DAh, video status
	testflag	al,8
	jz	WVRT
FastPut:
	;
	pop	cx
	loop	fntlpB
	add	[ScrnPnt],FONTW
charDn:	ret
put_chr	ENDP

;
; get the video state :
;
vstate	PROC	near
	push	dx ax
	mov	dx,3dah
not_zero:
	in	al,dx		; port 3DAh, video status
	testflag	al,8
	jnz	not_zero
if_zero:
	in	al,dx		; port 3DAh, video status
	testflag	al,8
	jz	if_zero
	pop	ax dx
	ret
vstate	ENDP

;
; Left string shift (low speed) :
; Do this 360 times, because its a byte move.
; call lssLO, POSITION
;
lssLO	PROC	near
	ARG	StringPosition:WORD
	mov	ax,0a000h
	mov	ds,ax
	mov	es,ax
	mov	si,StringPosition
	mov	di,si
	inc	si
	cld

	mov	cx,FONTH
fntHL:	push	cx
	mov	cx,MAXX-1
	repz	movsb
	pop	cx
	inc	si
	inc	di
	loop	fntHL
	ret
lssLO	ENDP

;
; Left string shift (hi speed) :
; Do this 320/2 times, because its a 2 byte move.
; call lssHI, POSITION
;
lssHI	PROC	near
	ARG	StringPosition:WORD
	mov	ax,0a000h
	mov	ds,ax
	mov	es,ax
	mov	si,StringPosition
	mov	di,si
	add	si,2
	cld

	mov	cx,FONTH
fntHH:	push	cx
	mov	cx,MAXX/2-1
	repz	movsw
	pop	cx
	add	si,2
	add	di,2
	loop	fntHH
	ret
lssHI	ENDP

;
; Right string shift (low speed) :
; Do this 360 times, because its a byte move.
; call rssLO, POSITION
;
rssLO	PROC	near
	ARG	StringPosition:WORD
	mov	ax,0a000h
	mov	ds,ax
	mov	es,ax
	mov	si,StringPosition
	dec	si
	add	si,320*FONTH
	mov	di,si
	dec	si
	std

	mov	cx,FONTH
rfntHL:	push	cx
	mov	cx,MAXX-1
	repz	movsb
	pop	cx
	dec	si
	dec	di
	loop	rfntHL
	ret
rssLO	ENDP

;
; Right string shift (hi speed) :
; Do this 160 times, because its a 2 byte move.
; call rssHI, POSITION
;
rssHI	PROC	near
	ARG	StringPosition:WORD
	mov	ax,0a000h
	mov	ds,ax
	mov	es,ax
	mov	si,StringPosition
	sub	si,2
	add	si,320*FONTH
	mov	di,si
	sub	si,2
	std

	mov	cx,FONTH
rfntHH:	push	cx
	mov	cx,MAXX/2-1
	repz	movsw
	pop	cx
	sub	si,2
	sub	di,2
	loop	rfntHH
	ret
rssHI	ENDP

;
; Just a different way to clear the screen :
;
damast	PROC
	mov	ax,0a000h
	mov	es,ax

	cld
	flipflag	di,di
	mov	cx,MAXX/3 * MAXY + 28
strpA:	mov	ax,es:[di]
	flipflag	al,al
	stosw
	inc	di
	loop	strpA
	call	vstate

	flipflag	di,di
	mov	cx,MAXX/3 * MAXY +28
strpB:	mov	ax,es:[di]
	flipflag	ah,ah
	stosw
	inc	di
	loop	strpB
	call	vstate

	flipflag	ax,ax
	flipflag	di,di
	mov	cx,MAXX/2 * MAXY
	repz	stosw
	ret
damast	ENDP

;
; User delay :
;
delay	PROC
dly:	push	cx
	call	vstate
	pop	cx
	loop	dly
	ret
delay	ENDP

;
; spt_str : Outputs a scrolling text string with grafical charakters.
; The string ends with a 0.
; Use : call spt_str y-position,offset FontData, offset String
;
spt_str	PROC	near
	ARG	YPosition:WORD,FontOff:WORD,StringOff:WORD
	mov	ax,@DATA
	mov	ds,ax
	mov	[TextPnt],0
	mov	ax,YPosition
	mov	[ScrnPnt],ax
sdotxt:	mov	ax,StringOff
	add	ax,[TextPnt]
	mov	si,ax
	flipflag	bx,bx
	mov	byte ptr bl,[si]
	cmp	bl,0
	je	stxtdn
	call	spt_chr, FontOff
	inc	[TextPnt]
	call	vstate
	jmp	sdotxt
stxtdn:	ret
spt_str	ENDP

;
; Subroutine used by spt_str.
; Use this toghether with the shift LEFT funktions to get a nice scroller.
; Output a single charakter. The charakter is stored in BX ( BL ).
; Features : BX = 32 -> space ( DI,SI += FONTW )
;
spt_chr	PROC	near
	ARG	FontOff:WORD
	mov	ax,@DATA		; Font address
	mov	ds,ax
	mov	ax,0a000h		; Screen address
	mov	es,ax
	mov	si,FontOff
	mov	di,[ScrnPnt]		; Screen spot
	cld

	cmp	bx,' '			; space
	jne	snoSpc
	mov	cx,FONTW
sSpcB:	push	ds es cx		; Scroll a little
	call	lssLO,MAXX*SDEPTH
	pop	cx es ds
	call	vstate
	loop	sSpcB
	jmp	schrDn			; All done now...
snoSpc:
	cmp	bx,'U'			; Vertical panning
	jb	sskpChA
	add	si,320*FONTH
sskpChA:
	cmp	bx,'h'			; Vertical panning
	jb	sskpChB
	add	si,320*FONTH
sskpChB:
	sub	bx,'A'			; Horizontal panning
	mov	ax,FONTW
	mul	bx
	add	si,ax

	mov	cx,FONTW
sfntlB:	push	cx
	mov	cx,FONTH
	push	si di
sspl:	movsb
	add	si,319
	add	di,319
	loop	sspl

	push	ds es cx		; Scroll a little
	call	lssLO,MAXX*SDEPTH
	pop	cx es ds di si
	inc	si

	mov	dx,3dah
sWVRT:	in	al,dx			; port 3DAh, video status
	testflag	al,8
	jz	sWVRT

	pop	cx
	loop	sfntlB

schrDn:	ret
spt_chr	ENDP

	end	Start