
/*
 *  SGLASS.C - Written by  the Schafts:
 *                              Debbie & George
 *                            SCREEN 9 Productions
 *
 ************************************************************
 ************************************************************
 *
 *      This is a test of recursion in C. It draws a figure, changes
 *      the size, and then redraws it. The redraw is done by a
 *      recursive call. It draws diamonds and boxes on a blue screen.
 *
 *
*/
#include <math.h>
#include <conio.h>
#include <graph.h>
#include <stdio.h>

#define ESC  27
int RR;                          /* ret area for random() subroutine   */
int box_point(int,int,int);      /* Recursive subroutine               */
int box_box(int,int,int);        /* Same                               */
int getkey(void);                /* Get decoded keypress no echo       */
int random(int);                 /* Generate Random Number 0 <= RR < n */
int HC,CH;                       /* ret areas for color and char       */
int max_col,max_row,limit,size,osize,distfact,x,y;
int in_size,o_size,unoo,onoo;

/**********************************************************************/
/*                        main                                        */
/**********************************************************************/

main(void)
{

    HC = 0;                     /* HC is used for setting the color */

    /* CHANGE THE NEXT TWO CONSTANTS FOR NON-EGA        */

    max_col = 640;              /* max col on EGA */
    max_row = 350;              /* max row        */

	x = max_col/2;          /* middle       */
	y = max_row/2;
 distfact = 2;                  /* multiplier for distance */
     size = 75;                 /* max size to grow to     */
    osize = 50;                 /* same                    */
    limit = 1;                  /* min. size of box - one row/col */

    in_size = 1;                /* starting size                */
    o_size  = 49;               /* same                         */
    unoo = 1;                   /* one - changed from + to -    */
    onoo = 1;                   /* same, for other drawing      */

    /* CHANGE THE CONSTANTS BELOW FOR NON-EGA           */

	 _setvideomode(_ERESCOLOR);     /* set to EGA high res  */
	 _setbkcolor(_LIGHTBLUE);       /* set background to _..*/
	 _clearscreen(_GCLEARSCREEN);   /* clear screen         */


	 HC = 1;                        /* starting color [BLUE] */



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



	while (1)                       /* until key hit        */
      {
	 HC = random(16);               /* get random color             */
	 _setcolor(HC);                 /* set color for DIAMOND        */
	 box_point(x,y,in_size);        /* call diamond draw            */
	 in_size += unoo;               /* add [ or subtract ] one      */
	 if(in_size == size) unoo = -1; /* if max, switch to subtract   */
	 if(in_size == 1)    unoo = 1;  /* if min, switch to add        */

	 HC = random(16);               /* get random color             */
	 _setcolor(HC);                 /* set color for BOX            */
	 box_box(x,y,o_size);           /* call box draw                */
	 o_size += onoo;               /* add[or subtract] one          */
	 if(o_size == osize) onoo = -1; /* if max, set to subtract      */
	 if(o_size == 1)     onoo = 1;  /* if min, set to add           */



	 if (kbhit() )                  /* check for keyboard hits      */
	  {
	   CH = getkey();
	   if (toupper(CH) == 'P')
	    CH = getkey();              /*    pause   */
	    if (CH == ESC)              /*    done    */
	    {
	    _setvideomode(_DEFAULTMODE);
	    exit (0);
	    }
	   }
/*  end the while and main                                         */
      }

}


/*******************************************************************/
/*                         box_box  -  draw boxes                  */


box_box(col_inpt,row_inpt,siz)
    int col_inpt,row_inpt,siz;
{
	int newsz,d,delay;
	newsz=d=0;


						/* check for limits */
	if (         siz > limit   &&
	    col_inpt+siz < max_col &&
	    col_inpt-siz > 0       &&
	    row_inpt+siz < max_row &&
	    row_inpt-siz > 0 )
	     {


		    _moveto(col_inpt+siz,row_inpt-siz);         /* draw box*/
		    _lineto(col_inpt+siz,row_inpt+siz);
		    _lineto(col_inpt-siz,row_inpt+siz);
		    _lineto(col_inpt-siz,row_inpt-siz);
		    _lineto(col_inpt+siz,row_inpt-siz);



		d = distfact*siz;       /* d represents 2 * curr size   */
		newsz = siz/2;          /* halve the size of the box    */

	/* The following is the recursive part of the call              */

		box_box(col_inpt,row_inpt-d,newsz);   /* to the top   */
		box_box(col_inpt,row_inpt+d,newsz);   /* to the bottom*/
		box_box(col_inpt+d,row_inpt,newsz);   /* to the right */
		box_box(col_inpt-d,row_inpt,newsz);   /* to the left  */
	     }
}

/*********************************************************************/
/*                         box_point  - draw diamonds                */
/*                     [same as box_box, essentially                 */




box_point(ccol,rrow,ssiz)
      int ccol,rrow,ssiz;
{
	int news,dd,ddly;
	news=dd=ddly=0;

	if(     ssiz > limit   &&
	   ccol+ssiz < max_col &&
	   ccol-ssiz > 0       &&
	   rrow+ssiz < max_row &&
	   rrow-ssiz > 0)
	 {

	   _moveto(ccol+ssiz,rrow);             /* draw diamond */
	   _lineto(ccol,rrow+ssiz);
	   _lineto(ccol-ssiz,rrow);
	   _lineto(ccol,rrow-ssiz);
	   _lineto(ccol+ssiz,rrow);


	   dd = distfact*ssiz;
	   news = ssiz/2;

	   box_point(ccol,rrow+dd,news);        /* to the bottom*/
	   box_point(ccol,rrow-dd,news);        /* to the top   */
	   box_point(ccol-dd,rrow,news);        /* to the left  */
	   box_point(ccol+dd,rrow,news);        /* to the right */

	 }
}


/*              M I S C.   S U B R O U T I N E S                        */
/*************************  getkey  -  get key press********************/

getkey()                  /* Get decoded keypress no echo */
{
   int CH;

   CH = getch();
   if (CH == 0)
      CH = 1000 + getch();
   return(CH);
}

/**************************  random  -  generate random nbr  ************/

int random(RR)                 /* Generate Random Number 0-RR */
int RR;
{
   int s;
   long t;

   s = rand();                  /* get nbr 0 - 32768            */
   t = (long) s * RR / 32768;   /* mult it by input, divide by max */
   return((int) t);             /* ret nbr between 0 and input nbr */
}
