(*
ͻ
 Turbo Pascal 6.0 Include File : SDFILE.INC                                
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 File-related routines for SORTDEMO.PAS                                    
ͼ
                                                                           *)
procedure AnalysisToFile (var Info  : InfoType;
                              Start : TimeDateType;
                              Stop  : TimeDateType;
                              Diff  : DiffType);
const
  AFileName = 'SDSTATS.DAT';

var
  AFile : text;

  (**)

  function FileExist ( FileName : string) : boolean;
  var
    DirInfo : SearchRec;

  begin (* FileExist *)
    FindFirst(FileName, Archive, DirInfo);
    if DosError = 0
      then FileExist := true
      else FileExist := false;
  end;  (* FileExist *)

  (**)

begin  (* AnalysisToFile *)
  assign(AFile, AFileName);
  if not FileExist(AFileName)
    then
      begin
        rewrite(AFile);
        writeln(AFile, 'SORTDEMO ANALYSIS FILE');
        writeln(AFile);
      end
    else
      begin
        append(AFile);
      end;

  writeln(AFile, 'Sort method: ', SortTitles[Ord(Info.Method)+1]);
  writeln(AFile, 'Array size:  [', Info.xElems:3, ',', Info.yElems:3,
                 '] = ', Info.Len:4, ' elements');
  writeln(AFile, 'Start time:  ', TimeDate2Str(Start));
  writeln(AFile, 'Stop time:   ', TimeDate2Str(Stop));

  writeln(AFile, 'Sort time:   Days    Hrs    Mins    Secs    100s');
  write(AFile, Diff.Days:17);
  write(AFile, Diff.Hours:7);
  write(AFile, Diff.Minutes:8);
  write(AFile, Diff.Seconds:8);
  write(AFile, Diff.Sec100s:8);
  writeln(AFile);
  writeln(AFile);
  writeln(AFile);

  close(AFile);
end;   (* AnalysisToFile *)

(**)
