(*
ͻ
 Turbo Pascal 6.0 Include File : SDGRAF.INC                                
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 Basic graphics routines for SORTDEMO.PAS                                  
ͼ
                                                                           *)

{$F+  force far calls on  }
function DetectVGA256 : integer;
var
 DetectedDriver : integer;
 SuggestedMode  : integer;

begin (* DetectVGA256 *)
  DetectGraph(DetectedDriver, SuggestedMode);
  if ((DetectedDriver = VGA) or (DetectedDriver = MCGA))
    then DetectVGA256 := 0
    else DetectVGA256 := grError;
end;  (* DetectVGA256 *)
{$F-  force far calls off }

(**)

procedure InitMode13h;
var
  PathToDriver  : string;
  grDriver      : integer;
  grMode        : integer;
  AutoDetectPtr : pointer;
  ErrorCode     : integer;

begin  (* InitMode13h *)
  DirectVideo := false;  (* allow writeln in graphics mode *)
  PathToDriver := '';
  repeat
    AutoDetectPtr := @DetectVGA256;
    grDriver := InstallUserDriver('VGA256', AutoDetectPtr);
    grDriver := Detect;
    InitGraph(grDriver, grMode, PathToDriver);
    ErrorCode := GraphResult;
    if (ErrorCode <> grOk) then
      begin
        writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
        if (ErrorCode = grFileNotFound)
          then
            begin
              writeln('Enter full path or type <Ctrl-Break> to quit:');
              readln(PathToDriver);
              writeln;
            end
          else
            begin
              writeln('Program terminated.');
              Halt(1);
            end;
      end; (* ErrorCode <> grOk *)
  until (ErrorCode = grOk);
end;   (* InitMode13h *)

(**)

procedure InitFonts;
begin  (* InitFonts *)
  if RegisterBGIFont(@SmallFontProc) < 0 then
    begin
      writeln('Error registering font: ', GraphErrorMsg(GraphResult));
      Halt(1);
    end;
  SetTextStyle(SmallFont, HorizDir, 4);
end;   (* InitFonts *)

(**)

procedure GetRGBPalette (var Pal : PaletteType);
var
  Regs : Registers;

begin  (* GetRGBPalette *)
  with Regs do
    begin
      AX := $1017;
      BX := 0;        (* start at color 0 *)
      CX := 256;      (* repeat for 256 colors *)
      ES := Seg(Pal);
      DX := Ofs(Pal);
    end;
  Intr($10, Regs);
end;   (* GetRGBPalette *)

(**)

procedure SetRGBPalette (var Pal : PaletteType);
var
  Regs : Registers;

begin  (* SetRGBPalette *)
  with Regs do
    begin
      AX := $1012;
      BX := 0;        (* start at color 0 *)
      CX := 256;      (* repeat for 256 colors *)
      ES := Seg(Pal);
      DX := Ofs(Pal);
    end;
  Intr($10, Regs);
end;   (* SetRGBPalette *)

(**)

procedure InitPalettes (var DefaultPalette : PaletteType;
                        var Palette        : PaletteType);
var
  i : byte;

begin  (* InitPalettes *)
  GetRGBPalette(DefaultPalette);  (* save the default palette *)
  Palette := DefaultPalette;      (* start with default then modify *)

  (* modify colors 0 & 32..71, (40 colors) *)

  Palette[0].Red := 8;
  Palette[0].Grn := 8;
  Palette[0].Blu := 8;

  with Palette[32] do begin  Red:=20; Grn:= 0; Blu:= 0;  end;
  with Palette[33] do begin  Red:=30; Grn:= 0; Blu:= 0;  end;
  with Palette[34] do begin  Red:=40; Grn:= 0; Blu:= 0;  end;
  with Palette[35] do begin  Red:=50; Grn:= 0; Blu:= 0;  end;
  with Palette[36] do begin  Red:=60; Grn:= 0; Blu:= 0;  end;
  with Palette[37] do begin  Red:=60; Grn:= 0; Blu:=30;  end;
  with Palette[38] do begin  Red:=60; Grn:= 0; Blu:=38;  end;
  with Palette[39] do begin  Red:=60; Grn:= 0; Blu:=45;  end;
  with Palette[40] do begin  Red:=60; Grn:= 0; Blu:=52;  end;
  with Palette[41] do begin  Red:=60; Grn:= 0; Blu:=60;  end;
  with Palette[42] do begin  Red:=50; Grn:= 0; Blu:=60;  end;
  with Palette[43] do begin  Red:=40; Grn:= 0; Blu:=60;  end;
  with Palette[44] do begin  Red:=30; Grn:= 0; Blu:=60;  end;
  with Palette[45] do begin  Red:=20; Grn:= 0; Blu:=60;  end;
  with Palette[46] do begin  Red:=15; Grn:= 0; Blu:=60;  end;
  with Palette[47] do begin  Red:= 0; Grn:= 0; Blu:=60;  end;
  with Palette[48] do begin  Red:= 0; Grn:=20; Blu:=60;  end;
  with Palette[49] do begin  Red:= 0; Grn:=30; Blu:=60;  end;
  with Palette[50] do begin  Red:= 0; Grn:=40; Blu:=60;  end;
  with Palette[51] do begin  Red:= 0; Grn:=50; Blu:=60;  end;
  with Palette[52] do begin  Red:= 0; Grn:=60; Blu:=60;  end;
  with Palette[53] do begin  Red:= 0; Grn:=60; Blu:=50;  end;
  with Palette[54] do begin  Red:= 0; Grn:=60; Blu:=40;  end;
  with Palette[55] do begin  Red:= 0; Grn:=60; Blu:=30;  end;
  with Palette[56] do begin  Red:= 0; Grn:=60; Blu:=20;  end;
  with Palette[57] do begin  Red:= 0; Grn:=60; Blu:= 0;  end;
  with Palette[58] do begin  Red:=30; Grn:=60; Blu:= 0;  end;
  with Palette[59] do begin  Red:=40; Grn:=60; Blu:= 0;  end;
  with Palette[60] do begin  Red:=50; Grn:=60; Blu:= 0;  end;
  with Palette[61] do begin  Red:=60; Grn:=60; Blu:= 0;  end;
  with Palette[62] do begin  Red:=63; Grn:=63; Blu:= 0;  end;
  with Palette[63] do begin  Red:=60; Grn:=50; Blu:= 0;  end;
  with Palette[64] do begin  Red:=60; Grn:=40; Blu:= 0;  end;
  with Palette[65] do begin  Red:=60; Grn:=30; Blu:= 0;  end;
  with Palette[66] do begin  Red:=60; Grn:=20; Blu:= 0;  end;
  with Palette[67] do begin  Red:=50; Grn:=20; Blu:= 0;  end;
  with Palette[68] do begin  Red:=40; Grn:=20; Blu:= 0;  end;
  with Palette[69] do begin  Red:=30; Grn:=20; Blu:= 0;  end;
  with Palette[70] do begin  Red:=25; Grn:=20; Blu:= 0;  end;
  with Palette[71] do begin  Red:=20; Grn:=20; Blu:= 0;  end;

  SetRGBPalette(Palette);
end;   (* InitPalettes *)
 
(**)

procedure DrawPanel (px1, py1, px2, py2    : integer;
                     MainCol, HiCol, LoCol : word;
                     Thick                 : byte);

var
  OldFill : FillSettingsType;
  OldCol  : word;
  i       : byte;

begin  (* DrawPanel *)
  GetFillSettings(OldFill);
  OldCol := GetColor;

  SetFillStyle(SolidFill, MainCol);
  Bar(px1,py1,px2,py2);
  SetColor(HiCol);

  for i := 1 to Thick do
    begin
      SetColor(HiCol);
      Line(px1-i, py1-i, px2+i, py1-i);
      Line(px1-i, py1-i, px1-i, py2+i);
      SetColor(LoCol);
      Line(px1-i, py2+i, px2+i, py2+i);
      Line(px2+i, py1-i, px2+i, py2+i);
    end;

  SetFillStyle(OldFill.Pattern, OldFill.Color);
  SetColor(OldCol);
end;   (* DrawPanel *)

(**)

procedure LoadArray (var Info : InfoType);
var
  i,r,c : word;

  (**)

  function CalcColor (var xElems : word; c : word) : word;

    (**)

    function Calc40 (c : word) : word;
    begin (* Calc40 *)
      Calc40 := 31+c;
    end;  (* Calc40 *)

    (**)

  begin (* CalcColor *)
    if xElems =  20 then CalcColor := Calc40(c*2);
    if xElems =  40 then CalcColor := Calc40(c);
    if xElems =  80 then CalcColor := Calc40((((c+3) div 2) - 1));
    if xElems = 160 then CalcColor := Calc40((((c+7) div 4) - 1));
  end;  (* CalcColor *)

  (**)

begin  (* LoadArray *)
  Info.Sorted := true;
  i := 0;

  for c := 1 to Info.xElems do
    for r := 1 to Info.yElems do
      begin
        Inc(i);
        Info.List[i].Key := i;
        Info.List[i].Color := CalcColor(Info.xElems, c);
      end;
end;   (* LoadArray *)

(**)

procedure ShowBlock (var Info : InfoType;
                         Index : IndexType);
var
  x, y, xBlock, yBlock : integer;

begin  (* ShowBlock *)
  x := (Index-1) div Info.yElems;
  y := (Index-1) mod Info.yElems;
  xBlock := xMax div Info.xElems;
  yBlock := yMax div Info.yElems;

  SetFillStyle(SolidFill, Info.List[Index].Color);
  Bar((x*xBlock), (y*yBlock),
     ((x*xBlock)+(xBlock-2)),((y*yBlock)+(yBlock-2)));
end;   (* ShowBlock *)

(**)

procedure ShowArray (var Info : InfoType);
var
  i : IndexType;

begin  (* ShowArray *)
  ClearDevice;
  for i := 1 to Info.Len do
    ShowBlock(Info, i);
end;   (* ShowArray *)

(**)
