(*
ͻ
 Turbo Pascal 6.0 Include File : SDMISC.INC                                
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 Misc routines for SORTDEMO.PAS                                            
ͼ
                                                                           *)
{$F+  force far calls on  }
procedure SortDemoExitProc;
begin  (* SortDemoExitProc *)
  ExitProc := OldExitProc;
  CloseGraph;
  writeln('Thanks for using SORTDEMO');
  writeln('by Jon S. Russell');
end;   (* SortDemoExitProc *)
{$F-  force far calls off }

(**)

procedure InitExitProc (var OldExitProc : pointer);
begin  (* InitExitProc *)
  (* initialize OldExitProc variable declared in SORTDEMO.PAS such that   *)
  (* anytime the program is terminated, SortDemoExitProc will be executed *)

  OldExitProc := ExitProc;        (* save original exit proc *)
  ExitProc := @SortDemoExitProc;  (* insert SortDemoExitProc into chain *)
end;   (* InitExitProc *)
 
(**)

procedure InitList (var Info : InfoType);
var
  i : word;

begin  (* InitList *)
  Info.xElems    := 20;
  Info.yElems    := 1;
  Info.Len       := Info.xElems*Info.yElems;
  Info.Method    := Bubble;
  Info.Operation := Mix;
  Info.Save      := false;
  Info.Sorted    := false;

  for i := 1 to MaxNumElements do
    Info.List[i].Key := i;
  LoadArray(Info);
end;   (* InitList *)

(**)

procedure Swap (var Info   : InfoType;
                    i1, i2 : word);
var
  Temp : ListElemType;

begin  (* Swap *)
  Temp := Info.List[i1];
  Info.List[i1] := Info.List[i2];
  Info.List[i2] := Temp;
  ShowBlock(Info, i1);
  ShowBlock(Info, i2);
end;   (* Swap *)

(**)

procedure MixArray (var Info : InfoType);
var
  i1,i2 : word;

begin  (* MixArray *)
  Info.Sorted := false;
  ShowArray(Info);
  FlushKeyBuffer;
  repeat
    i1 := Random(Info.Len) + 1;
    i2 := Random(Info.Len) + 1;
    Swap(Info, i1, i2);
  until KeyPressed;
end;   (* MixArray *)

(**)

procedure Beep;
begin  (* Beep *)
  sound(220);  (* 220 Hertz *)
  delay(100);  (* 100 ms    *)
  nosound;
end;   (* Beep *)

(**)
