(*
ͻ
 Turbo Pascal 6.0 Include File : SDSORT01.INC                              
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 Bubble sort routine for SORTDEMO.PAS                                      
ͼ
                                                                           *)
procedure BubbleSort (var Info : InfoType);
var
  Current : IndexType;

  (**)

  procedure BubbleUp (var Info       : InfoType;
                          StartIndex : IndexType;
                          EndIndex   : IndexType);
  var
    Index : IndexType;

  begin  (* BubbleUp *)

    (* Loop Invariant: StartIndex <= Index <= EndIndex AND *)
    (* List[Index+1] .. List[EndIndex] >= List[Index].     *)

    for Index := EndIndex downto StartIndex+1 do
      if (Info.List[Index].Key < Info.List[Index-1].Key)
        then Swap(Info,Index,Index-1);
  end;   (* BubbleUp *)

  (**)

begin  (* BubbleSort *)
  Current := 1;  (* index of first unsorted element *)

  (* Loop Invariant: 1 <= Current <= Info.Len AND    *)
  (* the values in List[1] .. List[Current-1] are    *)
  (* sorted and are less than or equal to the values *)
  (* in List[Current] .. List[Len].                  *)

  while Current < Info.Len do
    begin
      (* Bubble up the smallest element from the unsorted *)
      (* part of the list, with intermediate swaps.       *)

      BubbleUp(Info, Current, Info.Len);

      (* Shrink the unsorted part of the list *)

      Inc(Current);
    end;  (* while *)

  Info.Sorted := true;  (* set flag *)
end;   (* BubbleSort *)

(**)
