(*
ͻ
 Turbo Pascal 6.0 Include File : SDSORT02.INC                              
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 Short-bubble sort routine for SORTDEMO.PAS                                
ͼ
                                                                           *)
procedure ShortBubbleSort (var Info : InfoType);
var
  Current     : IndexType;
  DoneSorting : boolean;

  (**)

  procedure BubbleUp (var Info        : InfoType;
                          StartIndex  : IndexType;
                          EndIndex    : IndexType;
                      var DoneSorting : boolean);
  var
    Index : IndexType;

  begin  (* BubbleUp *)
    DoneSorting := true;  (* start out optimistic *)

    (* Loop Invariant:  StartIndex <= Index <= EndIndex AND *)
    (* List[Index+1] .. List[EndIndex] >= List[Index].      *)

    for Index := EndIndex downto StartIndex+1 do
      if (Info.List[Index].Key < Info.List[Index-1].Key) then
        begin
          Swap(Info,Index,Index-1);
          DoneSorting := false;
        end;
  end;   (* BubbleUp *)

  (**)

begin  (* ShortBubbleSort *)
  Current := 1;   (* index of first unsorted element *)
  DoneSorting := false;

  (* Loop Invariant: 1 <= Current <= Info.Len AND    *)
  (* the values in List[1] .. List[Current-1] are    *)
  (* sorted and are less than or equal to the values *)
  (* in List[Current] .. List[Len].                  *)

  while (not DoneSorting) and (Current < Info.Len) do
    begin

      (* Bubble up the smallest element from unsorted *)
      (* part of the list, with intermediate swaps.   *)

      BubbleUp(Info, Current, Info.Len, DoneSorting);

      (* Shrink the unsorted part of the list. *)

      Inc(Current);
    end; (* while *)

  Info.Sorted := true;  (* set flag *)
end;   (* ShortBubbleSort *)

(**)
