(*
ͻ
 Turbo Pascal 6.0 Include File : SDSORT03.INC                              
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 Selection sort routine for SORTDEMO.PAS                                   
ͼ
                                                                           *)
procedure SelectionSort (var Info : InfoType);
var
  Current  : IndexType;
  Smallest : IndexType;

  (**)

  function MinIndex (var List       : ListType;
                         StartIndex : IndexType;
                         EndIndex   : IndexType) : IndexType;

  var
    Min   : IndexType;  (* index of smallest element so far *)
    Index : IndexType;  (* loop control variable            *)

    (* MinIndex = index of smallest element in the subarray *)
    (* List[StartIndex] .. List[EndIndex].                  *)

  begin (* MinIndex *)
    Min := StartIndex;

    (* Loop Invariant: List[Min] is the smallest element *)
    (* in List[StartIndex] .. List[Index-1] AND          *)
    (* StartIndex <= Index <= EndIndex+1.                *)

    for Index := StartIndex+1 to EndIndex do
      if (List[Index].Key < List[Min].Key) then Min := Index;

    MinIndex := Min;
  end;  (* MinIndex *)

  (**)

begin  (* SelectionSort *)
  Current := 1;  (* index of first unsorted element *)

  (* Loop Invariant: 1 <= Current <= Info.Len AND the  *)
  (* values in List[1] .. List[Current-1] are sorted   *)
  (* and are less than or equal to the unsorted values *)
  (* in List[Current] .. Info[Len].                    *)

  while Current < Info.Len do
    begin
      (* Find the smallest element in the unsorted part. *)
      Smallest := MinIndex(Info.List, Current, Info.Len);

      (* Swap the Current element and the smallest  *)
      (* element in the unsorted part of the array. *)
      Swap(Info, Current, Smallest);

      (* Shrink the unsorted part of the array. *)
      Inc(Current);
    end; (* while *)

  Info.Sorted := true;  (* set flag *)
end;   (* SelectionSort *)

(**)
