(*
ͻ
 Turbo Pascal 6.0 Include File : SDSORT05.INC                              
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 Quick-Sort #1 routine for SORTDEMO.PAS                                    
ͼ
                                                                           *)
procedure QuickSort1 (var Info  : InfoType;
                          First : IndexType;
                          Last  : IndexType);
var
  SplitPoint : IndexType;

  (**)

  procedure Split (var Info       : InfoType;
                       First      : IndexType;
                       Last       : IndexType;
                   var SplitPoint : IndexType);

    (* Choose SplitVal and rearrange List so that:       *)
    (* List[First] .. List[SplitPoint-1] <= SplitVal and *)
    (* List[SplitPoint] = SplitVal and                   *)
    (* List[SplitPoint+1] .. List[Last] > SplitVal.      *)

  var
    SplitVal  : ListElemType;  (* value on which to split *)
    SaveFirst : IndexType;     (* original value of First *)

  begin  (* Split *)
    (* SplitVal is chosen from the First array slot. *)
    SplitVal := Info.List[First];

    (* Set up for split loop. *)
    SaveFirst := First;
    Inc(First);

    (* Loop Invariant: elements to the left of First are *)
    (* less than or equal to SplitVal'  elements to the  *)
    (* right of Last are greater than SplitVal           *)
    repeat
      (* Increment First until element > SplitVal. *)
      while (First < Last) and (Info.List[First].Key <= SplitVal.Key) do
        inc(First);

      (* Check end condition. *)
      if (First = Last) and (Info.List[First].Key <= SplitVal.Key) then
        inc(First);

      (* decrement Last until element > SplitVal. *)
      while (First <= Last) and (Info.List[Last].Key > SplitVal.Key) do
        dec(Last);

      (* If First and Last are on the wrong side of the *)
      (* split point, then swap them;  update First and *)
      (* Last to set up to continue splitting.          *)
      if (First < Last) then
        begin
          Swap(Info, First, Last);
          inc(First);
          dec(Last);
        end;
    until First > Last;

    (* Set SplitPoint to place where the halves meet. *)
    SplitPoint := Last;

    (* Swap SplitVal with element at SplitPoint. *)
    Swap(Info, SaveFirst, SplitPoint);
  end;   (* Split *)

  (**)

begin  (* QuickSort1 *)
  Info.Sorted := false;  (* reset flag *)

  if First < Last then  (* General Case *)
    begin

      (* Procedure Split chooses the splitting value and *)
      (* rearranges the array so that:                   *)
      (* List[First] .. List[SplitPoint-1] <= SplitVal   *)
      (* List[SplitPoint] = SplitVal AND                 *)
      (* List[SplitPoint+1] .. List[Last] > SplitVal.    *)
      Split(Info, First, Last, SplitPoint);

      (* Sort the left "half." *)
      QuickSort1(Info, First, SplitPoint-1);

      (* Sort the right "half." *)
      QuickSort1(Info, SplitPoint+1, Last);
    end;

  Info.Sorted := true;  (* set flag *)
end;   (* QuickSort1 *)

(**)
