(*
ͻ
 Turbo Pascal 6.0 Include File : SDTIME.INC                                
Ķ
 Program : SORTDEMO.PAS                                                    
Ķ
 Version : 1.0                                                             
Ķ
 Copyright (c) 1992  by  Jon S. Russell                                    
Ķ
 Time-keeping routines for SORTDEMO.PAS                                    
ͼ
                                                                           *)
procedure GetTimeDate (var TD : TimeDateType);
begin  (* GetTimeDate *)
  GetTime(TD.Time.Hour, TD.Time.Minute, TD.Time.Second, TD.Time.Sec100);
  GetDate(TD.Date.Year, TD.Date.Month, TD.Date.Day, TD.Date.DayOfWeek);
end;   (* GetTimeDate *)

(**)

procedure CalcTimeDateDifference (    Start : TimeDateType;
                                      Stop  : TimeDateType;
                                  var Diff  : DiffType);
var
  JulianStart : real;
  JulianStop  : real;

  (**)

  function Julian (    InYear  : word;
                       InMonth : word;
                       InDay   : word) : real;
  var
    Cent     : integer;
    CentY    : integer;
    Month    : integer;
    Year     : integer;
    OutDay   : integer;
    LongDay  : real;
    TempLong : real;

  begin  (* Julian *)
    if (InMonth > 2)
      then
        begin
          Month := InMonth-3;
          Year := InYear;
        end
      else
        begin
          Month := InMonth+9;
          Year := InYear-1;
        end;

    TempLong := 146097;
    Cent := Year div 100;
    CentY := Year - (Cent * 100);
    LongDay := TempLong * Cent / 4;
    LongDay := LongDay + 1461.0 * CentY / 4;
    LongDay := LongDay + (153 * Month + 2) / 5;
    LongDay := LongDay + InDay;
    Julian := LongDay;
  end;   (* Julian *)

  (**)

  procedure BorrowDay (var Time : TimeType;
                       var Days : word);

  begin  (* BorrowDay *)
    inc(Time.Hour, 24);
    dec(Days);
  end;   (* BorrowDay *)

  (**)

  procedure BorrowHour (var Time : TimeType;
                        var Days : word);

  begin  (* BorrowHour *)
    if (Time.Hour = 0) then BorrowDay(Time, Days);
    inc(Time.Minute, 60);
    dec(Time.Hour);
  end;   (* BorrowHour *)

  (**)

  procedure BorrowMinute (var Time : TimeType;
                          var Days : word);

  begin  (* BorrowMinute *)
    if (Time.Minute = 0) then BorrowHour(Time, Days);
    inc(Time.Second, 60);
    dec(Time.Minute);
  end;   (* BorrowMinute *)

  (**)

  procedure BorrowSecond (var Time : TimeType;
                          var Days : word);

  begin  (* BorrowSecond *)
    if (Time.Second = 0) then BorrowMinute(Time, Days);
    inc(Time.Sec100, 100);
    dec(Time.Second);
  end;   (* BorrowSecond *)

  (**)

begin  (* CalcTimeDateDifference *)
  JulianStart := Julian(Start.Date.Year, Start.Date.Month, Start.Date.Day);
  JulianStop := Julian(Stop.Date.Year, Stop.Date.Month, Stop.Date.Day);
  Diff.Days := round(JulianStop - JulianStart);

  if (Start.Time.Sec100 > Stop.Time.Sec100)
    then BorrowSecond(Stop.Time, Diff.Days);
  Diff.Sec100s := Stop.Time.Sec100 - Start.Time.Sec100;

  if (Start.Time.Second > Stop.Time.Second)
    then BorrowMinute(Stop.Time, Diff.Days);
  Diff.Seconds := Stop.Time.Second - Start.Time.Second;

  if (Start.Time.Minute > Stop.Time.Minute)
    then BorrowHour(Stop.Time, Diff.Days);
  Diff.Minutes := Stop.Time.Minute - Start.Time.Minute;

  if (Start.Time.Hour > Stop.Time.Hour)
    then BorrowDay(Stop.Time, Diff.Days);
  Diff.Hours := Stop.Time.Hour - Start.Time.Hour;
end;   (* CalcTimeDateDifference *)

(**)

function TimeDate2Str ( TD : TimeDateType) : string;
var
  TimeStr : string;
  DateStr : string;

  (**)

  procedure Blanks2Zeros (var S : string);
  begin  (* Blanks2Zeros *)
    while (pos(' ', S) > 0) do
      S[pos(' ', S)] := '0';
  end;   (* Blanks2Zeros *)

  (**)

  function Time2Str ( Time : TimeType) : string;
  var
    TimeStr : string;
    UnitStr : string;

  begin (* Time2Str *)
    str(Time.Hour:2, UnitStr);
    TimeStr := UnitStr + ':';
    str(Time.Minute:2, UnitStr);
    TimeStr := TimeStr + UnitStr + ':';
    str(Time.Second:2, UnitStr);
    TimeStr := TimeStr + UnitStr + ':';
    str(Time.Sec100:2, UnitStr);
    TimeStr := TimeStr + UnitStr;

    Blanks2Zeros(TimeStr);

    Time2Str := TimeStr;
  end;  (* Time2Str *)

  (**)

  function Date2Str ( Date : DateType) : string;
  var
    DateStr : string;
    UnitStr : string;

  const
    DayName : array[0..6] of string[3] =
      ('Sun', 'Mon', 'Tue', 'Wed', 'Thr', 'Fri', 'Sat');

  begin (* Date2Str *)
    str(Date.Month:2, UnitStr);
    DateStr := UnitStr + '-';
    str(Date.Day:2, UnitStr);
    DateStr := DateStr + UnitStr + '-';
    str(Date.Year:4, UnitStr);
    DateStr := DateStr + UnitStr;

    Blanks2Zeros(DateStr);
    DateStr := DayName[Date.DayOfWeek] + ', ' + DateStr;

    Date2Str := DateStr;
  end;  (* Date2Str *)

  (**)

begin (* TimeDate2Str *)
  TimeStr := Time2Str(TD.Time);
  DateStr := Date2Str(TD.Date);

  TimeDate2Str := DateStr + ' @ ' + TimeStr;
end;  (* TimeDate2Str *)

(**)
