UNIT SuperVGA;   { by The Faker in 1993 }

INTERFACE
CONST
     NoVGA=0;
     VGA=1;
     Tseng=2;
     Trident=3;
     ATI=4;
     Paradise=5;
VAR
   Card:Byte;
   ATI_Ext:Word;

PROCEDURE SelectBank(Nr:Byte);

PROCEDURE GrafikKarte;

PROCEDURE SwitchMode;

IMPLEMENTATION

PROCEDURE SelectBank(Nr:Byte);
BEGIN
     IF Card=Tseng THEN
        Port[$3CD]:=(Nr AND 7)+(Port[$3CD] AND $F8)
     ELSE
     IF Card=Trident THEN
        PortW[$3C4]:=$E+(Nr XOR 2) SHL 8
     ELSE
     IF Card=ATI THEN
     BEGIN
          ASM
             mov bl,nr
             mov dx,ati_ext
             mov al,$b2
             out dx,al
             inc dx
             in al,dx
             mov ah,al
             and ah,$f0
             shl bl,1
             or ah,bl
             mov al,$b2
             dec dx
             out dx,ax
          END;
     END
     ELSE
     IF Card=Paradise THEN
     BEGIN
          Port[$3CE]:=9;
          Port[$3CF]:=Nr SHL 4;
          Port[$3CE]:=$A;
          Port[$3CF]:=Nr SHL 4;
     END;
END;

FUNCTION IsItTseng:Boolean;
VAR
   Dummy,OldValue,NewValue,Value:Byte;
BEGIN
     Port[$3BF]:=3;
     IF Port[$3CC] AND 1=1 THEN
        Port[$3D8]:=$A0
     ELSE Port[$3B8]:=$A0;
     Dummy:=Port[$3DA];
     Port[$3C0]:=$16;
     OldValue:=Port[$3C1];
     Dummy:=Port[$3DA];
     Port[$3C0]:=$16;
     NewValue:=OldValue XOR $10;
     Port[$3C0]:=NewValue;
     Dummy:=Port[$3DA];
     Port[$3C0]:=$16;
     Value:=Port[$3C1];
     Dummy:=Port[$3DA];
     Port[$3C0]:=$16;
     Port[$3C0]:=OldValue;
     IsItTseng:=Value=NewValue;
END;

FUNCTION IsItTrident:Boolean;
VAR
   Dummy,OldValue,NewValue,Value:Byte;
BEGIN
     Port[$3C4]:=$E;
     OldValue:=Port[$3C5];
     Port[$3C5]:=0;
     Value:=Port[$3C5] AND $F;
     Port[$3C5]:=OldValue;
     IsItTrident:=Value=2;
END;

FUNCTION IsItATI:Boolean;
CONST
     ID:ARRAY[1..9] OF Char='761295520';
VAR
   I:Byte;
BEGIN
     IsItATI:=FALSE;
     FOR I:=1 TO 9 DO
         IF Ord(ID[I])<>Mem[$C000:$30+I] THEN
            Exit;
     ATI_Ext:=MemW[$C000:$10];
     IsItATI:=TRUE;
END;

FUNCTION IsItParadise:Boolean;
BEGIN
     IsItParadise:=MemL[$C000:$7D]=$3D414756;
END;

PROCEDURE GrafikKarte;
VAR
   IsVGA:Byte;
BEGIN
     ASM
        mov ax,$1a00
        int $10
        mov isvga,al
     END;
     IF IsVGA<>$1A THEN
        Card:=NoVGA
     ELSE
     IF IsItTrident THEN
        Card:=Trident
     ELSE
     IF IsItTseng THEN
        Card:=Tseng
     ELSE
     IF IsItATI THEN
        Card:=ATI
     ELSE
     IF IsItParadise THEN
        Card:=Paradise
     ELSE Card:=VGA;
     ASM
        mov ax,3
        int $10
     END;
END;

PROCEDURE SwitchMode;
VAR
   ModeControl:Byte;
BEGIN
     IF Card=Tseng THEN
        ModeControl:=$2E
     ELSE
     IF Card=Trident THEN
        ModeControl:=$5D
     ELSE
     IF Card=ATI THEN
        ModeControl:=$62
     ELSE Exit;
     ASM
        mov al,modecontrol
        xor ah,ah
        int $10
     END;
END;

BEGIN
     GrafikKarte;
END.
