/*****************************************************************************

	Tools per utility DOS - Di Davide Achilli - 18 Maggio 1992

*****************************************************************************/
#include <dir.h>
#include <string.h>
#include <ctype.h>
#include "DosUtil.h"

#define MAX_FLAGS  20
#define MAX_PATHS   5
#define PATH_LEN   80

char paths [MAX_PATHS][PATH_LEN];
int  flags [MAX_FLAGS];
char validList [MAX_FLAGS];

/*----------------------------------------------------------------------------
	Questa funzione analizza gli argc/argv e compila una lista speciale di
	parametri
----------------------------------------------------------------------------*/
TParRes analyzeParams (int argC, char *argV [], char *valid)
{
	int i;
	int availPath = 0;
	char *ptr;
	strcpy (validList, valid);

	/*--------------------------------------------------------------------------
		Resetta tutte le variabili flags.
	--------------------------------------------------------------------------*/
	for (i = 0; i < MAX_FLAGS; flags [i++] = 0);

	/*--------------------------------------------------------------------------
		Resetta tutte le variabili paths.
	--------------------------------------------------------------------------*/
	for (i = 0; i < MAX_PATHS; paths [i++][0] = (char) 0);

	/*--------------------------------------------------------------------------
		Scanna i parametri uno per uno...
	--------------------------------------------------------------------------*/
	for (i = 1; i < argC; i++) {

		/*------------------------------------------------------------------------
			Controlla l'eventuale presenza del carattere '/' o '-' come primo
			carattere di un parametro che denota la	presenza di un parametro.
		------------------------------------------------------------------------*/
		if (strchr ("-/", argV [i][0]) != NULL) {

			/*----------------------------------------------------------------------
				Vede se il parametro flag esiste nella lista inviata e in che posi-
				zione e'.
			----------------------------------------------------------------------*/
			if ((ptr = strchr (valid, toupper (argV [i][1]))) != NULL) {
				flags [(int) (ptr - valid)] = 1;
			}
			else return parUnknown;
		}

		/*------------------------------------------------------------------------
			Se no e' un path!
		------------------------------------------------------------------------*/
		else {
			strcpy (paths [availPath], argV [i]);
			availPath ++;
		}
	}
	if (i == 1) return parMissing;
	return parOk;
}

/*----------------------------------------------------------------------------
	Ritorna, in base alla lettera richiesta, se era true o no.
----------------------------------------------------------------------------*/
int flag (char letter)
{
	char *ptr;

	/*----------------------------------------------------------------------
		Vede se il parametro flag esiste nella lista inviata e in che posi-
		zione e'.
	----------------------------------------------------------------------*/
	if ((ptr = strchr (validList, letter)) != NULL) {
		return flags [(int) (ptr - validList)];
	}
	return 0;
}

/*----------------------------------------------------------------------------
	Ritorna il puntatore dell'n-esimo path inserito o NULL se il path richies-
	to non e' stato inserito dall'utente.
----------------------------------------------------------------------------*/
char *path (int n)
{
	if ((n < 0) || (n >= MAX_PATHS)) return NULL;
	if (paths [n][0] == 0) return NULL;
	return paths [n];
}

/*----------------------------------------------------------------------------
	Cambia l'estensione ad un path se questa manca.
----------------------------------------------------------------------------*/
void changeExt (char *path, char *newExt)
{
	char drive [MAXDRIVE];
	char dir   [MAXDIR];
	char file  [MAXFILE];
	char ext   [MAXEXT];
	int flags;

	flags = fnsplit (path, drive, dir, file, ext);

	if (!(flags & EXTENSION)) {
		fnmerge (path, drive, dir, file, newExt);
	}
}
