/*
   TTGA.c
 ------------------------------------------------------------------------------
                    HCTARGA.H, HCTGAV.C, HCSVGAS.LIB are
               Copyright 1990,1991 of Synergrafix Consulting
                          All Rights Reserved.
 ------------------------------------------------------------------------------
 *                                                                            *
 * TTGA.EXE - TsengTGA                       18/05/92    by Luigino Masarati  *
 *                                                                            *
 * v1.0                                                                       *
 *                                                                            *
 ------------------------------------------------------------------------------
*/

#include <stdio.h>
#include <string.h>
#include "hctarga.h"
#include "dosutil.h"

#define   VERSION           "1.0"

char errmsg[256];
int i;

void header()  {
    printf("\nTsengTGA v%s\n",VERSION);
    printf("(c)1992 by Luigino Masarati.\n");
    printf("Targa 32/24/16 File Utility for Tseng ET4000 HiColor.\n\n");
    }

void usage()  {
		printf("Usage: TTGA <options> filename[.TGA] [output16file[.TGA]]\n");
		printf("<options>:\n");
		printf("-d = Dithering on                   -h = Help\n");
		printf("-c = Save Compressed Targa16 File   -? = Help\n");
		}

void error(char *s) {
	fcloseall();
    hctextmode();
    header();
    printf("%s\n",s);
	exit(1);
	}
								/* Routine to analize parameters */

int main(int argc,char *argv[]) {

    int err,mode,w,h,commentsize;
    unsigned char comment[256];

    switch (analyzeParams (argc, argv, "DCH?")) {

		case parMissing: {
						header();
						printf("Missing Parameter!\n\n");
						usage();
						exit(1);
		}

		case parUnknown: {
            header();
            printf("Unknown Parameter!\n\n");
            usage();
            exit(1);
        }
    }

		if (flag('H')||flag('?')) {
        header();
        usage();
				exit(1);
				}

						/* Checks if inputfile exists */

		if (path (0) != NULL) {
				changeExt (path (0), ".TGA");
				if (access(path(0),0)!=0) {
					header();
					printf("Cannot find %s !\n",path(0));
					exit(1);
				}

						/* Get size of TGA file */

    err=hctgasize(path(0),&w,&h,&commentsize,&comment);
	switch (err) {
		case HCTGACANTOPEN:
            error("Can't open input file!");
			break;
		case HCTGANOMEM:
			error("Not enough memory to load file!");
		case HCTGANOTSUPPORTED:
			error("File type not supported!");
		case HCTGACANTREAD:
			error("Error reading file!");
		}

						/* Set Hicolor mode */

	mode=hcmodesize(w,h);
	if (mode<2) mode=2;
	if (mode>3) mode=3;
	if (!hcsetmodetseng(mode))
		error("No HiColor DAC, not Tseng Chipset, or can't set mode!");


						/* View TGA file */

    err=hctgaview(path(0),-1,-1,-1,-1,(flag ('D')));
	switch (err) {
		case HCTGACANTOPEN:
            error("Can't open input file!");
			break;
		case HCTGANOMEM:
			error("Not enough memory to load file!");
		case HCTGANOTSUPPORTED:
			error("File type not supported!");
		case HCTGACANTREAD:
			error("Error reading file!");
		}
	}
	else {
		header();
		printf("Filename missing!\n\n");
		exit(1);
        }

												/* Save TGA 16 Compressed File */

    if (path (1) != NULL) {
        changeExt (path (1), ".TGA");
        err=hctgasave(path(1),-1,-1,-1,-1,(flag ('C')),commentsize,&comment);
        switch (err) {
            case HCTGACANTOPEN:
                error("Can't open output file!");
                break;
            case HCTGANOMEM:
                error("Not enough memory to save file!");
            case HCTGACANTWRITE:
                error("Error writing output file!");
            }
        }

		sound(300);
		delay(20);
    nosound();

	getch();                           	/* Exit */

	hctextmode();
    header();
        printf("This program is 'GratisWare', distribute it all around the world !\n");

	return 0;
	}


