UNIT Mus;
{$O+,F+}

INTERFACE

CONST ON=TRUE; OFF=FALSE;       { Eks: MusCursor(ON) eller MusCursor(OFF)   }

VAR   MusK,MusX,MusY:WORD;      { Musposisjon, X,Y og Knapper               }

FUNCTION  ResetMus:BOOLEAN;     { Returnerer TRUE om musen er resatt riktig }
FUNCTION  MusON:BOOLEAN;        { Er MusCursoren P eller Av                }
PROCEDURE MusCursor(B:BOOLEAN); { Sl muscursoren P eller Av               }
PROCEDURE SaveMus;              { Lagre Musposisjon, sl av muscursor       }
PROCEDURE RestoreMus;           { Hent frem igjen Muscursor etter SaveMus   }
PROCEDURE MusData;              { Hent data om knapper posisjon og lignende }

IMPLEMENTATION

VAR Mb,Sm:BOOLEAN;

FUNCTION ResetMus:BOOLEAN;
 VAR T:WORD;
 BEGIN
   ASM MOV AX,$0000; INT $33; MOV T,AX; END;
   ResetMus:=T<>$0000;
 END;

PROCEDURE MusCursor(B:BOOLEAN);
 BEGIN
   Mb:=B;
   IF B THEN ASM MOV AX,$0001; INT $33; END
        ELSE ASM MOV AX,$0002; INT $33; END;
 END;

FUNCTION  MusON:BOOLEAN; BEGIN MusON:=Mb;              END;
PROCEDURE SaveMus;       BEGIN Sm:=Mb; MusCursor(OFF); END;
PROCEDURE RestoreMus;    BEGIN MusCursor(Sm);          END;

PROCEDURE MusData;
 BEGIN
   ASM MOV AX,$0003; INT $33; MOV MusK,BX; MOV MusX,CX; MOV MusY,DX; END;
   MusX:=MusX DIV 8+1; MusY:=MusY DIV 8+1;
 END;

BEGIN
  MusCursor(OFF); Mb:=OFF; Sm:=OFF;
  IF NOT ResetMus THEN
   BEGIN
     WRITELN('Fr ikke kontakt med musen, kontakt systemansvarlig.');
     Halt;
   END;
   ASM
     MOV       AX,$000A
     MOV       BX,$0000
     MOV       CX,$F700
     MOV       DX,$0CFF
     INT       $33
   END;
END.