UNIT TxtMouse;

INTERFACE

CONST     ON          = TRUE;
          OFF         =FALSE;
          None        =    0;
          Left        =    1;
          Right       =    2;
          Middle      =    3;

VAR       MouseButtons,
          MouseXpos,
          MouseYpos   :BYTE;

FUNCTION  MouseReset:BOOLEAN;
PROCEDURE Mouse(mode:BOOLEAN);
PROCEDURE MouseEndInterrupt;
PROCEDURE MouseInitiateInterrupt;
PROCEDURE MouseSetPosition(x,y:BYTE);

IMPLEMENTATION

VAR       MouseOldInterrupt:POINTER;
          MouseState:BOOLEAN;

FUNCTION  InterruptVector(pntr:POINTER; itr:BYTE):POINTER;
 BEGIN
   ASM CLI END;
   InterruptVector:=Ptr(MemW[0:itr*4+2],MemW[0:itr*4]);
   MemW[0:itr*4]:=Ofs(pntr^); MemW[0:itr*4+2]:=Seg(pntr^);
   ASM STI END;
 END;

{$F+}
PROCEDURE MouseInterrupt; INTERRUPT; ASSEMBLER;
 ASM
     MOV  ax,$0003
     INT  $33
     SHR  cx,3
     SHR  dx,3
     INC  cx
     INC  dx
     MOV  MouseButtons,bl
     MOV  MouseXpos,cl
     MOV  MouseYpos,dl
     PUSHF
 END;
{$F-}

FUNCTION  MouseReset:BOOLEAN; ASSEMBLER;
 ASM
     MOV  ax,$0000
     INT  $33
 END;

PROCEDURE Mouse(mode:BOOLEAN); ASSEMBLER;
 ASM
     MOV  ax,$0002
     MOV  bl,mode
     MOV  MouseState,bl
     CMP  bl,OFF
     JE   @nx
     MOV  ax,$0001
@nx: INT  $33
 END;

PROCEDURE MouseInitiateInterrupt;
 BEGIN
   MouseOldInterrupt:=InterruptVector(@MouseInterrupt,$1C);
    ASM
     MOV  ax,$0003
     INT  $33
     SHR  cx,3
     INC  cx
     SHR  dx,3
     INC  dx
     MOV  MouseXpos,cl
     MOV  MouseYPos,dl
     MOV  MouseButtons,bl
    END;
 END;

PROCEDURE MouseEndInterrupt;
 BEGIN
   InterruptVector(MouseOldInterrupt,$1C);
 END;

PROCEDURE MouseSetPosition(x,y:BYTE); ASSEMBLER;
 ASM
     MOV  ax,$0004
     MOV  cl,x
     MOV  ch,$00
     DEC  cx
     SHL  cx,3
     MOV  dl,y
     MOV  dh,$00
     DEC  dx
     SHL  dx,3
     INT  $33
 END;


BEGIN
END.