#include "stdio.h"
#include "process.h"
#include "conio.h"
#include "alloc.h"
#include "dos.h"
#include "graphics.h"
#include "mem.h"

typedef struct {
				char manufacturer;
				char version;
				char encoding;
				char bits_per_pixel;
				int xmin,ymin;
				int xmax,ymax;
				int hres;
				int vres;
				char palette[48];
				char reserved;
				char colour_planes;
				int bytes_per_line;
				int palette_type;
				char filler[58];
				} PCXHEAD;

char palette[768];
PCXHEAD header;
unsigned int width,depth;
unsigned int bytes,bits;

error(char *s);
UnpackPcxFile(FILE *fp);
void init(void);
setvgapalette(char *p);
ReadPcxLine(char *p,FILE *fp);
void deinit(void);

main(int argc,char *argv[])

	 {
	 FILE *fp;

	 /* check for arguments */
	 if(argc<=1) error("I need a pth to a PCX file");

	 /* attempt to open the file */
	 if((fp=fopen(argv[1],"rb")) == NULL)
		 error("Error opening the file");

	 /* read in the header */
	 if(fread((char *)&header,1,sizeof(PCXHEAD),fp) != sizeof(PCXHEAD))
		 error("Error reading the PCX header");

	 if(header.bits_per_pixel == 1) bits=header.colour_planes;
	 else bits=header.bits_per_pixel;

	 /* check to make sure it's a picture */
	 if(header.manufacturer != 0x0a || header.version != 5 )
		 error("This is not a suitable PCX file");

		if(bits !=8) error("This file has the wrong number of colors");

		/* Find the palette */
		if(!fseek(fp,-769L,SEEK_END)) {
			if(fgetc(fp)!=0x0c || fread(palette,1,768,fp)!=768)
			 error("Error reading the palette");
			 }
			else error("Error seeking to palette");
		fseek(fp,128L,SEEK_SET);

	 /* allocate a big buffer */
	 width = (header.xmax-header.xmin)+1;
	 depth = (header.ymax-header.ymin)+1;
	 bytes=header.bytes_per_line;

	 /* unpack the file */
	 UnpackPcxFile(fp);

	 fclose(fp);

	 return(0);
}

/* open and print image */
UnpackPcxFile(FILE *fp)
{
		 int i;

		 init();
		 setvgapalette(palette);

		 /* unpack the file directly to the VGA buffer */
		 for(i=0;i<depth;++i)
		 {
			/* don't unpack more lines than there are on screen */
			if(i>=200) break;
			ReadPcxLine((char *)MK_FP(0xa000,i*320),fp);
			}
			getch();
			deinit();
	 }

		/* read and decode a PCX line into p */
	 ReadPcxLine(char *p,FILE *fp)
	 {
			int n=0,c,i;

			/* null the buffer */
			memset(p,0,bytes);
			do {
					/* get a key byte */
					c=fgetc(fp) & 0xff;
					/* if it's a run of bytes field */
					if((c & 0xc0) == 0xc0) {
						 /* and off the high bits */
						 i=c & 0x3f;
						 /* get the run byte */
						 c=fgetc(fp);
						 /* run the byte */
						 while(i--) p[n++]=c;
					}
					/* else just store it */
						else p[n++]=c;
					} while(n < bytes);
					return(n);
			}

			void init(void)
			/* turn on graphics mode */

			{
			 union REGS r;

			 r.x.ax=0x0013;
			 int86(0x10,&r,&r);
			}

	 void deinit(void)  /* turn off graphics card */
	 {
			union REGS r;

			r.x.ax=0x0003;
			int86(0x10,&r,&r);
	 }


	 /*set the VGA palette to RGB buffer p */
	 setvgapalette(char *p)
	 {
		 union REGS r;
		 struct SREGS sr;
		 int i;

		 /* convert eight bits to six bits */
		 for(i=0;i<768;++i) p[i]=p[i] >> 2;

		 r.x.ax=0x1012;
		 r.x.bx=0;
		 r.x.cx=256;
		 r.x.dx=FP_OFF(p);
		 sr.es=FP_SEG(p);
		 int86x(0x10,&r,&r,&sr);
	 }

		error(char *s)
		{
		 puts(s);
		 exit(1);
	 }
















