void main()
{
	int i, j;
	static unsigned char cmap[256][3];
	static unsigned char rect[32*32];
	
	vgainit (0x101);

	for (i=0; i<256; i++)
		cmap[i][0] = cmap[i][1] = cmap[i][2] = i;

	cmap[0][0] = cmap[0][1] = cmap[0][2] = 0;	/* 0 = black */
	cmap[1][0] = cmap[1][1] = cmap[1][2] = 63;	/* 1 = white */

	for (i=0; i<8; i++) {
		cmap[i+2][0] = cmap[i+2][1] = 0;	/* 2-9 = blues */
		cmap[i+2][2] = (i<<3)+7;

		cmap[i+10][0] = cmap[i+10][2] = 0;	/* 10-17 = greens */
		cmap[i+10][1] = (i<<3)+7;

		cmap[i+18][2] = cmap[i+18][1] = 0;	/* 18-25 = reds */
		cmap[i+18][0] = (i<<3)+7;

		cmap[i+26][0] = 0;			/* 26-31 = cyans */
		cmap[i+26][1] = cmap[i+26][2] = (i<<3)+7;

		cmap[i+32][1] = 0;			/* 32-39 = magentas */
		cmap[i+32][0] = cmap[i+32][2] = (i<<3)+7;

		cmap[i+40][2] = 0;			/* 40-47 = yellows */
		cmap[i+40][1] = cmap[i+26][0] = (i<<3)+7;

		cmap[i+48][0] = cmap[i+48][1] = cmap[i+48][2] = (i<<3)+7;
							/* 48-55 = grays */
	}
	
	
	vgasetcolor (cmap, 0, 256);

	for (j=0; j<128; j++)
		for (i=0; i<240; i++)
 			vgahline (i<<1, 10, 399, i+j);
	for (i=0; i<256; i++)
		vgapoint (i, i, 255-i);

	for (j=2; j<256; j++)
		for (i=50; i<250; i += 20) {
			vgaline (150, 150, 250, i, j);
			vgaline (150, 150, 50, 300-i, j);
			vgaline (150, 150, i, 50, j);
			vgaline (150, 150, 300-i, 250, j);
		}
	for (j=0; j<256; j++)
		vgafill (0, 0, 640, 480, j);

	for (i=0; i<32; i++)
		for (j=0; j<32; j++)
			rect[i*32+j] = i+abs(16-j);

	for (i=0; i<15; i++)
		for (j=0; j<20; j++)
			vgarect (rect, 32, i*32, j*32, 32, 32);
}
