/****************************************************************************/
/*  video  version 0.22                                                     */
/*                                                                          */
/* program to access the video-blaster and compatible cards                 */
/* for the GNU djgpp/gcc compiler                                           */
/*                                                                          */
/* (C)1994 Bernhard Schwall                                                 */
/*                                                                          */
/* version 0.1                                                              */
/*    show the video under dos and linux and control the sound              */
/*    (on Media Pro Plus)                                                   */
/*                                                                          */
/* version 0.2                                                              */
/*   save and load single pictures in .TGA format                           */
/*                                                                          */
/* version 0.21                                                             */
/*   grayscale software video without saving and loading                    */
/*                                                                          */
/* version 0.22                                                             */
/*   renamed to vid_bw.c because of problems with DOS                       */
/*                                                                          */
/****************************************************************************/

#include "v_access.h"
#include <stdio.h>
#include <string.h>
#include <vga.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdlib.h>
#include <time.h>

/****************************************************************************/

void init(char *Path, INT clear){
char Name[200];
int i;

  strcpy(Name, Path);
  strcat(Name,"video.cfg");
  vga_disabledriverreport();
  vga_init();
  vga_setmode(G320x240x256);
  for (i=0; i<64; i++){
    vga_setpalette(i, i, i, i);
  }
  V_Initialize(Name, clear);
}

/****************************************************************************/

void done(){
  V_Exit();
  vga_setmode(TEXT);
}

/***************************************************************************/

void Display_video(char *Buffer, int SizeX, int SizeY, int XOff, int YOff){
  int x,y;
  BYTE *src, *org;
  BYTE *dest=(BYTE *)Buffer;
  
  org = (BYTE *)VidMem;
  V_FreezeVideo();
  for (y=0; y<SizeY; y++){
    src = org;
    for (x=0; x<SizeX; x++){
      *dest++ = *src>>2;
      src+=2;
    }
    org += 2048;
  }
  V_UnfreezeVideo();
  for (y=0; y<SizeY; y++){
    vga_drawscansegment(Buffer, XOff, y+YOff, SizeX);
    Buffer+=SizeX;
  }
}

/**************************************************************************/

int main(int argc, char *argv[])
{
  char ch;
  int Mute = 0;
  int Volume;
  int XRes, YRes, XOff, YOff;
  int Freeze = 0;
  char *Buffer;
  clock_t time1, time2, time3;
  long Count=0;

  init("", 0);
  Volume = V_GetVolume();
  V_CreateWindow(0,0,XRes=320,YRes=240); 
  XOff = 0;
  YOff = 0;
  V_DisableVideo();
  Buffer=(char *)malloc(XRes*YRes*4);

  do {
    time1=clock();
    while ((ch = vga_getkey()) == 0){
      if (Freeze == 0){
        time3 = clock();
        Display_video(Buffer, XRes, YRes, XOff, YOff);
        Count++;
        switch (XRes){
        case 320: break;
        /* reduce framerate to 11 frames per second */
        /* more isn't possible with my card         */
        case 240: while ((clock()-time3) < (int)(100/11));
                  break;
        case 160: break;
        }
      }
    }
    time2=clock()-time1;
    switch (ch){
    case 's': Freeze ^= 1;
              break;
    case '2': printf("%ix%i: %i Bilder, nearly. %f frames per second\n",
                 XRes, YRes, (int)Count,
                 (float)Count/((float)time2/100));
              V_CreateWindow(0,0,XRes=320,YRes=240); 
              V_DisableVideo();
              Count = 0;
              XOff = 0;
              YOff = 0;
              vga_clear();
              break;
    case '3': printf("%ix%i: %i frames, nearly. %f frames per second\n",
                 XRes, YRes, (int)Count,
                 (float)Count/((float)time2/100));
              V_CreateWindow(0,0,XRes=240,YRes=180); 
              V_DisableVideo();
              Count = 0;
              XOff = 40;
              YOff = 30;
              vga_clear();
              break;
    case '4': printf("%ix%i: %i frames, nearly %f frames per second\n",
                 XRes, YRes, (int)Count,
                 (float)Count/((float)time2/100));
              V_CreateWindow(0,0,XRes=160,YRes=120); 
              V_DisableVideo();
              Count = 0;
              XOff = 80;
              YOff = 60;
              vga_clear();
              break;

    case 'l': Volume += 8;
              if (Volume > 255) Volume = 255;
              V_SetVolume(Volume);
              break;
    case 'q': Volume -= 8;
              if (Volume < 0) Volume = 0;
              V_SetVolume(Volume);
              break;
    case '+': Volume += 2;
              if (Volume > 255) Volume = 255;
              V_SetVolume(Volume);
              break;
    case '-': Volume -= 2;
              if (Volume < 0) Volume = 0;
              V_SetVolume(Volume);
              break;
    case 'm': if (Mute == 0){
                Mute = Volume;
                V_SetVolume(0);
              }
              else {
                V_SetVolume(Mute);
                Mute = 0;
              }
              break;
    }
  } while (ch != 27);
  done();
  free(Buffer);
  printf("%iX%i: %i Bilder, nearly. %f frames per second\n",
          XRes, YRes, (int)Count, 
          (float)Count/((float)time2/100));
  return 0;
}
