
/*

         VMode.C

         Monitor Driver detector.

         This program will detect the type of monitor driver
         attached to the calling PC.

         The number referenced is a DOS ErrorCode that is set
         when the program terminates.

              Display Adapters:   1 MONO
                                  2 CGA
                                  3 EGA
                                  4 VGA
                                  5 HERC
                                  6 CMPQ
                                  0 SPCL (Unknown monitor)

         If VMode is called with an argument, a help display will
         be printed listing the above table.

         Date      : 4/24/90
         Version   : 1.0

         Author    : F. Brett Platko
                   
*/

/* [] ==========================  Includes  ==========================[] */

#include      <stdlib.h>
#include      <stdio.h>
#include      <dos.h>


/* [] ==========================  Globals   ==========================[] */

int      eCode;


/* [] ======================= Function Decl ==========================[] */

void     DisplayHelp    (void);
int      GetMonAdptr    (void);
int      GetGraphMode   (int *);


/* [] ==========================  [MAIN ()] ==========================[] */

void     main (int argc, char *argv[])
{

    int       mType          = 0;

         /*   Display Help Screen arg is passed.      */

    if (argc >= 2)
    {
         DisplayHelp();
         exit (-1);
    }
    
         /*   Get monitor type                        */
    
    mType = GetMonAdptr();

         /*   Set exit code                           */

    switch (mType)
    {
         case 00:

              eCode = 0;

              break;

         case 10:

              eCode = 1;

              break;

         case 20:

              eCode = 2;

              break;

         case 30:
         case 31:
         case 32:

              eCode = 3;

              break;

         case 40:

              eCode = 4;

              break;

         case 50:
         case 51:
         case 52:

              eCode = 5;

              break;

         case 60:

              eCode = 6;

              break;

         default:

              eCode = 0;

              break;

    }

    exit (eCode);
}


/* [] ======================= MonitorFunctions ======================[] */

/* [] ------------------------  GetMonAdptr   -----------------------[] */

int      GetMonAdptr    (void)
{

    union  REGS    reg;
    struct SREGS   inreg;

    int  adapter;                 /* Variable for Initial video mode      */
    int  gMode;                   /* Variable for Monitor display mode    */
    int  i;                       /* Counter                              */
    int  n;                       /* Counter                              */

    int retraceBit = 0;           /* Hercules detector variable           */
    int testBit;                  /* Hercules temporary variable          */

    int   type = 0;               /* Hardware type (Default is SPCL)      */
    char  buffer[64];             /* Temp buffer for BIOS Call            */

    int86 (0x11, &reg, &reg);     /* Get Equipment List                   */

    adapter   =    ((reg.h.al & 0x30) >> 4);     /* Get bits 4 & 5        */

         /* adapter (defaults)    0 = EGA, CGA, or Compaq
                                  1 = CGA (40x25)
                                  2 = VGA, EGA, CGA, Compaq (80x25 Color)
                                  3 = MDA, or Hercules (80x25 Mono)
         */

    gMode     =    GetGraphMode (&n);  

         /* gMode (defaults)      2 = Compaq 
                                  3 = VGA, EGA, or CGA
                                  7 = MDA, or Hercules
         */

    if ((gMode == 7) && (adapter == 3))
    {
         /*   0x3BA (CRT controller Display Status Port) if bit 7 changes the
              board is an Hercules. (Bit 7 is the vertical-retrace)
         */

         while (retraceBit != (inportb (0x3BA) & 0x80))    
         {
              retraceBit = (inportb (0x3BA) & 0x80);
         }

         /*   Test to see bit 7 changes     */

         for (i = 0; i <= 0x1000; i++)
         {
              testBit = inportb (0x3BA);

              if (retraceBit != (testBit & 0x80))
              {
                   testBit = (testBit & 0x70);

                   /* Bit 7 changed, Test for type of Herc board */

                   switch (testBit)
                   {
                        case 0x50:          /* ID Mask 01010000 */

                             type = 51;     /* Herc InColor     */

                             return (type);

                        case 0x10:          /* ID Mask 00010000 */

                             type = 52;     /* Herc Plus        */

                             return (type);

                        default:            /* Herc Graphics has no ID Mask */

                             type = 50;     /* Herc Graphics                */

                             return (type);
                   }
              }
         }

              /* Bit 7 did not change so must be IBM Mono card  */

         type = 10;                         /* IBM Mono         */

         return (type);
    }

    if (gMode == 3)
    {
         segread (&inreg);

         inreg.es  =    inreg.ds;

         reg.x.di  =    (int) buffer;
         reg.x.ax  =    0x1B00;
         reg.x.bx  =    0x00;

              /*   Test for VGA by performing ROM BIOS VGA 0x1B call, if 
                   a value 0x1B is return in al, then VGA
              */

         int86x (0x10, &reg, &reg, &inreg);

         if (reg.h.al == 0x1B)
         {
              type = 40;                              /* VGA          */

              return (type);
         }

              /*   Test for EGA (ah = 0x12, bl = 0x10) 
                   returns:  (bh = 0: Color Mode)
                             (     1: Mono Mode)
                             (bl = 0:  64 K)
                             (     1: 128 K)
                             (     2: 192 K)
                             (     3: 256 K)
              */

         reg.h.ah  = 0x12;
         reg.h.bl  = 0x10;

         int86 (0x10, &reg, &reg);

         if (reg.h.bl != 0x10)
         {
              switch (reg.h.bh)
              {

                   case 0:
                             type = 31;               /* EGA Color   */

                             break;

                   case 1:
                             type = 32;               /* EGA Mono    */

                             break;
                   default:

                             type = 30;               /* EGA         */
              }

              return (type);
         }


         if ((adapter == 2) || (adapter == 0))
         {
              type = 20;                              /* CGA        */

              return (type);
         }
    }


    if (gMode == 2)
    {
         type = 60;                                   /* COMPAQ     */
         return (type);
    }

    type = 00;

    return (type);
}


/* [] ------------------------  GetGraphMode  -----------------------[] */

int      GetGraphMode    (int *pNCols)
{
    /*   Get Current Video Mode   (ah = 0x0F)
         Returns                  (al = Current display Mode)
                                  (ah = Number of char per line)
                                  (bh = Active display page number)
    */
                                  
    
    union REGS     reg;

    reg.h.ah  = 0x0F;

    int86 (0x10, &reg, &reg);

    *pNCols   = reg.h.ah;
    
    return (reg.h.al);

}


/* [] ------------------------  DisplayHelp   -----------------------[] */

void     DisplayHelp    (void)
{
    printf ("\n\n");
    printf ("                          VMode.Com                       \n\n");

    printf ("                Monitor Hardware Driver Detector.         \n\n");

    printf ("      This program will detect the type of monitor driver   \n");
    printf ("      attached to the calling PC.                         \n\n");

    printf ("      Display Adapters: 1 MONO                              \n");
    printf ("        (Error Code)    2 CGA                               \n");
    printf ("                        3 EGA                               \n");
    printf ("                        4 VGA                               \n");
    printf ("                        5 HERC                              \n");
    printf ("                        6 CMPQ                              \n");
    printf ("                        0 SPCL (Unknown monitors)         \n\n");

    printf ("      Date      : 4/24/90                                   \n");
    printf ("      Version   : 1.0                                       \n");
    printf ("      Author    : F. Brett Platko                         \n\n");
  

}
