	COMMENT $

/* Data structures for 3D modelling */

/* Written for assembly by Dave Stampe, December 1993 */
/* base on 3dstruct.h */

/*
 This code is part of the REND386 project, created by Dave Stampe and
 Bernie Roehl.

 Copyright 1992, 1993, 1994 by Dave Stampe and Bernie Roehl.

 May be freely used to write software for release into the public domain;
 all commercial endeavours MUST contact BOTH Bernie Roehl and Dave Stampe
 for permission to incorporate any part of this software into their
 products!  Usually there is no charge for under 50-100 items for
 low-cost or shareware, and terms are reasonable.  Any royalties are used
 for development, so equipment is often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to REND386, Dave Stampe,
 and Bernie Roehl in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!  No more
 code ripoffs please.

 CONTACTS: dstampe@psych.toronto.edu, broehl@sunee.uwaterloo.ca
 See the COPYRITE.H file for more information.
*/



/* NOTE ON FORMATS:
 <nn.ff> means that nn bits are available as the integer part, and
 ff bits are used as a fractional part.  Multiply a float by 2^ff
 to get a long value to feed in.

 World coordinates should be kept below signed 24 bits (16.7M) to
 assure no errors.  This allows a range of 1mm->16.7 km, which
 should be plenty!

 Angles are in <16.16> format, where the integer part is in degrees.
*/
		$


		; Actual structure of a homogenous matrix


MATRIX STRUC
MAT_xx	dd ?    ; col. 1
MAT_yx	dd ?
MAT_zx	dd ?
MAT_xy	dd ?    ; col. 2
MAT_yy	dd ?
MAT_zy	dd ?
MAT_xz	dd ?    ; col. 3
MAT_yz	dd ?
MAT_zz	dd ?
MAT_xt	dd ?    ; translations
MAT_yt	dd ?
MAT_zt	dd ?
MATRIX ENDS

;/* new vertex copies, internal to renderer */
;typedef struct nV NVERTEX;
;struct nV{
;		long  x, y, z;       	  /* viewport coordinates (used for saving time) */
;	  	long  xs, ys ;          /* screen coordinates */
;		unsigned char outcode;  /* XY clip outcodes */
;		unsigned char perspect; /* flags perspective done */
;		};

NVERTEX STRUC
NV_x	dd ?
NV_y	dd ?
NV_z	dd ?

NV_xs	dd ?
NV_ys	dd ?

NV_ocode db ?
NV_persp db ?
NVERTEX ENDS

OLEFT   equ 1  		; /* XY outcode bits */
ORIGHT  equ 2
OTOP    equ 4
OBOTTOM equ 8


;/* world database vertices */
;/* object coords are referenced to object */
;/* world coords are updated when moving or rotating object */
;/* all others are renderer workspace */
;
;typedef struct {
;	long ox, oy, oz;   /* object coordinates */
;	long x, y, z;      /* world coordinates  */
;	long cz;	   /* converted Z coord  */
;	NVERTEX *new_copy;  /* non-zero if x and y transformed */
;	unsigned char z_transformed;   /* non-zero if z has been transformed */
;	unsigned char z_outcode;       /* 1 set if hither, 2 set if yon */
;	} VERTEX;

VERTEX STRUC
V_ox	dd ?
V_oy	dd ?
V_oz	dd ?

V_x	dd ?
V_y	dd ?
V_z	dd ?

V_cz	dd ?

V_nvptr dd ?

V_zxflag db ?
V_zocode db ?
VERTEX ENDS


OHITHER equ 16		; /* Z outcode bits */
OYON    equ 32


;/* world database polys */
;/* object-based normal must be rotated to world copy with object */
;/* color will have 8-bit color, 8-bit reflectance field */
;
;typedef struct {
;	unsigned color;   /* color (not used yet-- will set chroma, reflectance */
;	VERTEX **points;  /* array of pointers to the vertices of this polygon */
;	int npoints;      /* number of entries in points[] */
;	long onormalx,
;	     onormaly,
;	     onormalz;    /* unit length surface normal (VISOBJ) */
;	long normalx,
;	     normaly,
;	     normalz;     /* unit length surface normal (WORLD)*/
;	struct _object *object;
;	} POLY;


POLY STRUC
P_color 	dw ?
P_points	dd ?
P_npoints	dw ?

P_onormx	dd ?
P_onormy	dd ?
P_onormz	dd ?

P_normx 	dd ?
P_normy 	dd ?
P_normz 	dd ?

P_objptr	dd ?
POLY ENDS


;/* renderer poly copy */
;/* paernt points back to original poly for lighting */
;/* color computed by cosine lighting */
;/* maxz is deepest poly point for sorting */
;
;typedef struct {
;	int npoints;       /* number of entries in points[] MUST BE FIRST */
;	POLY *parent;
;	unsigned color;	   /* color after illumination */
;	long maxz;        /* maximum Z value (for sorting) */
;	} NPOLY;

NPOLY STRUC
NP_npoints	dw ?
NP_parent	dd ?
NP_color	dw ?
NP_maxz		dd ?
NPOLY ENDS


;typedef struct { NPOLY *ptr; long depth; } DSORT; /* used for depth sorting */

DSORT STRUC
DS_ptr  	dd ?
DS_depth	dd ?
DSORT ENDS


;typedef struct _rep {        /* a representation for an object */
;	long size;            /* if the object is bigger than this, use this rep */
;	int nverts, npolys;   /* number of vertices, number of polys */
;	VERTEX *verts;        /* array of vertices */
;	POLY *polys;          /* array of polygons */
;	struct _rep *next;    /* pointer to next rep in list */
;	long update_count;    /* inc. every time rep moves */
;	unsigned flags;
;	} REP;


REPR STRUC
R_size		dw ?
R_nverts	dw ?
R_npolys	dw ?

R_verts		dd ?
R_polys 	dd ?
R_next		dd ?

R_ucount	dd ?
R_flags		dw ?
REPR ENDS


;/* world database object */
;/* sphx, sphy, sphz, sphr used for sphere object clipping */
;
;#define OBJ_FLAG_MASK 0x7C00
;#define OBJ_DEPTH_MASK 0x03FF
;
;
;struct _object
; {
;	unsigned int oflags;
;#define OBJ_REPLOCK      0x0400
;#define OBJ_NONSEL       0x0800 /* can't be selected (i.e. pointer) */
;#define OBJ_INVIS        0x1000
;#define OBJ_HIGHLIGHTED  0x2000
;#define OBJLIST_HEADER   0x4000
;#define IS_VISOBJ        0x8000	/* required by renderer: it will set */
;
;#define DEEPEST 0x0000		/* sort polys by deepest point */
;#define ATBACK  0x0001		/* push this object's poly's waaaay back */
;#define AVERAGE 0x0002		/* sort polys by average depth */
;
;#define BYOBJECT   0x0100	/* sort by object */
;#define BYPOLY     0x0000	/* put polys in world before sort */
;
;	struct _object *prev;
;	struct _object *nnext;
;
;	void *owner;       /* for example, a body segment description struct */
;	REP *replist;              /* pointer to list of representations */
;	REP *current_rep;          /* the currently-active rep */
;
;	long osphx, osphy, osphz;     /* object-coord sphere center */
;	long sphx, sphy, sphz, sphr;  /* bounding sphere center and radius */
;	long update_count;         /* inc. every time object moved */
; };
;

VISOBJ 	STRUC
O_flags		dw ?

O_prev		dd ?
O_nnext		dd ?
O_owner		dd ?

O_replist	dd ?
O_currep 	dd ?

O_osphx   	dd ?
O_osphy   	dd ?
O_osphz   	dd ?

O_sphx   	dd ?
O_sphy   	dd ?
O_sphz   	dd ?
O_sphr   	dd ?

O_ucount	dd ?
VISOBJ	ENDS


OBJ_FLAG_MASK 	equ	7C00h
OBJ_DEPTH_MASK	equ	03FFh

OBJ_REPLOCK  	equ	0400h
OBJ_NONSEL   	equ	0800h   ;/* can't be selected (i.e. pointer) */
OBJ_INVIS    	equ	1000h
OBJ_HIGHLIGHTED	equ	2000h
OBJLIST_HEADER	equ	4000h
IS_VISOBJ   	equ	8000h	;/* required by renderer: it will set */

DEEPEST 	equ	0000h 	;/* sort polys by deepest point */
ATBACK  	equ	0001h 	;/* push this object's poly's waaaay back */
AVERAGE 	equ	0002h	;/* sort polys by average depth */

BYOBJECT   	equ	0100h	;/* sort by object */
BYPOLY     	equ	0000h	;/* put polys in world before sort */


;/* world database object list head */
;/* dual linked for fast remove/insert needed for splits */
;
;typedef struct _objlist
; {
;	unsigned int oflags;
;
;	struct _object *prev;
;	struct _object *nnext;
; } OBJLIST;

OBJLIST STRUC
OL_flags	dw ?
OL_prev		dd ?
OL_nnext	dd ?
OBJLIST ENDS


;/* renderer viewpoint/screen control structure */
;/* viewoint in X, Y, Z coords */
;/* pan, tilt, roll in (float*65536) formats */
;/* zoom is equiv. to magnification from 90 deg. FOV (also float*65536) */
;/* aspect sets how much to magnify Y more than X to fix up displays */
;/* light source point in world coordinates */
;/* left, right, top, bottom set edges of screen */
;/* hither sets closest point: keep >16 for best range of world coords */
;/* yon sets max. distance: keep it 1<<26 if not used */
;/* all others are renderer workspace */
;
;typedef struct {
;		     /* VIEWPOINT */
;	long zoom;              /* <16.16> 1/tan(H FOV/2) 0.5 to 16     */

;				 /* SCREEN DATA */
;	long left,right;        /* <25.0> clipping planes */
;	long top, bottom;
;	long hither, yon;   /* <25.0> near and far clipping planes   */
;	long aspect;		/* <16.16> x:y fixup factor (magnify Y by..*/
;
;	/* RENDERING CONTROL */
;	unsigned flags;     /* 16 bits of flags */
;
;				 /* ADVANCED SCREEN DATA */
;	long x_offset, y_offset; /* amount to move screen center in pixels */
;	unsigned orientation;    /* used to mirror screen image */
;	MATRIX eye_xform;
;
;		     /* INTERNAL RECORDS */
;	long hsw, hsh;		/* half screen width, height */
;	long hsc, vsc;		/* screen center (with offset) */
;	long scx, scy;		/* full-resolution scaling for horizon */
;	long sx,sy;		/* mantissa of screen scaling  */
;	int  xshift, yshift;    /* scaling bit shifts */
;
;	long left_C, left_M;    /* spherical clip coefficients */
;	long right_C, right_M;
;	long top_C, top_M;
;	long bot_C, bot_M;
;
;	long fac1,fac2,fac3,
;	     fac4,fac5,fac6,
;	     fac7,fac8,fac9;    /* conversion coefficients */
;
;	long sfac1,sfac2,sfac3, /* scaled conversion factors */
;			 sfac4,sfac5,sfac6;
;	       } VIEW;

VIEW STRUC
VP_zoom		dd ?

VP_left		dd ?
VP_right	dd ?
VP_top		dd ?
VP_bottom	dd ?
VP_hither	dd ?
VP_yon		dd ?

VP_aspect	dd ?
VP_flags	dw ?

VP_xoffset	dd ?
VP_yoffset	dd ?
VP_orientation	dw ?

VP_xform00	dd ?	; MATRIX
VP_xform01	dd ?
VP_xform02	dd ?
VP_xform10	dd ?
VP_xform11	dd ?
VP_xform12	dd ?
VP_xform20	dd ?
VP_xform21	dd ?
VP_xform22	dd ?
VP_xform30	dd ?
VP_xform31	dd ?
VP_xform32	dd ?

VP_hsw		dd ?
VP_hsh		dd ?
VP_hsc		dd ?
VP_vsc		dd ?

VP_scx		dd ?
VP_scy		dd ?
VP_sx		dd ?
VP_sy		dd ?

VP_xshift	dw ?
VP_yshift	dw ?

VP_left_C	dd ?
VP_left_M	dd ?
VP_right_C	dd ?
VP_right_M	dd ?
VP_top_C 	dd ?
VP_top_M 	dd ?
VP_bot_C 	dd ?
VP_bot_M 	dd ?

VIEW ENDS

NOFLIP 	equ	0      ;/* for orientation flags */
XFLIP 	equ	1
YFLIP 	equ	2

WIREFRAME           equ	0001h ;/* View flags: */
HIDE_HIGHLIGHTED    equ	0002h
HIDE_UNHIGHLIGHTED  equ	0004h


PRESCALE  	equ	2      ;/* frac bits in XY coords */
PRESCALEZ 	equ	2

;struct Screeninfo {
;	int xmin, ymin, xmax, ymax, xcent, ycent, colors, pages, bw;
;	long aspect;
;	char id[80];
;	};

SCREENINFO STRUC
S_xmin  	dw ?
S_ymin  	dw ?
S_xmax   	dw ?
S_ymax   	dw ?

S_xcent  	dw ?
S_ycent  	dw ?
S_colors	dw ?
S_pages 	dw ?
S_bw		dw ?

S_aspect	dd ?
S_id		db 80 dup (?)
SCREENINFO ENDS

OUT_OF_VIEW 	equ	80000000h  ; returned by clip_by_volume() if out

