/* Handles body/head/manipulator mappings */

/* Written by Dave Stampe, 4/1/94 */


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/

#include <stdio.h>
#include <stdlib.h>    /* atexit() */
#include <dos.h>

#include "pointer.h"
#include "vr_api.h"
#include "intmath.h"
#include "splits.h"
#include "pcdevice.h"
#include "segment.h"



OBJECT *body_seg = NULL;  /* body-in-world base segment */
OBJECT *head_seg = NULL;  /* head-on-body segment */
OBJECT *wrist_seg = NULL; /* wrist-on-body segment */

extern PDRIVER *head_device;


/* do BEFORE loading, initializing devices */
// creates default camera, etc.


void init_body_links() /* setup body-glove-head system */
{
 extern int use_ht;

 if(!body_seg) body_seg = new_seg(NULL);  // same as invisible object
 if(!head_seg) head_seg = new_seg(NULL);
 attach_object(head_seg, body_seg,0);
 if(!wrist_seg) wrist_seg = new_seg(NULL);
 attach_object(wrist_seg, body_seg,0);

 abs_rot_segment(head_seg, 0*65536L, 0*65536L, 0, RYXZ);

 set_object_pose(body_seg,body_pose);
 update_object(body_seg);
 attach_camera(current_camera, head_seg);
}


/* sequence: update cursor/glove, read head tracker, */
/* body_centric_map(), manipulate object, and render */

OBJECT *body_vehicle_object = NULL;

void update_body_links()
{
  set_object_pose(body_seg,body_pose);
  if (!body_vehicle_object) update_object(body_seg);
  else update_object(body_vehicle_object);
}


void disconnect_body()
{
  MATRIX m;

  update_body_links();	// make current

  if(body_vehicle_object) detach_object (body_seg,1);
  get_object_matrix_pose(body_seg, body_pose);
  body_vehicle_object = NULL;
}


void connect_body(OBJECT *s)
{
 MATRIX m;
 POSE p;

  update_body_links();	// make current

 if(body_vehicle_object)
      disconnect_body();
 if(!s) return;

 attach_object(body_seg, s, 1);
 get_object_matrix_pose(body_seg, body_pose);

 body_vehicle_object = s;
}
