/* Old animation routines for sample virtual world */

/* Written by Bernie Roehl, July 1992 */
// PORTED TO vr-386 api BY dAVE sTAMPE, 9/1/94

// This code is old now: animation support will be much better
// usingg STATMACH.C and new functions in the pipeline


// OLD OLD CODE: NOT REALLY UPDATED FOR API.
// USE AT OWN RISK!  TASKS WILL CHANGE IN FUTURE API RELEASES!


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "vr_api.h"
#include "intmath.h"
#include "oldtasks.h"

#define MAXSPINCOLORS 100

typedef struct {
	OBJECT *obj;
	int np; /* number of polys in obj */
	int ncolors;
	unsigned colors[MAXSPINCOLORS];
} SPINDATA;

extern void *objectlist;
extern void *find_name();

void spinner(int cmd, char *init, long now, long period)
{
  char *colorlist, *q;
  SPINDATA *data, **dataptr;
  int i, color;
  switch (cmd)
    {
      case 0:
	if ((data = malloc(sizeof(SPINDATA))) == NULL) return;
	dataptr = find_task_data(get_current_task());
	*dataptr = data;
	data->ncolors = 0;
	if ((colorlist = strchr(init, ';')) != NULL)
	  {
	    *colorlist++ = '\0';
	    for (colorlist = strtok(colorlist, ","); colorlist; colorlist = strtok(NULL, ","))
			if (data->ncolors >= MAXSPINCOLORS)
					break;
			else
					data->colors[data->ncolors++] = strtoul(colorlist, NULL, 0);
	  }
	data->obj = find_name(objectlist, init);
	if (data->obj) get_obj_info(data->obj, NULL, &data->np);
			break;
     case 1:
	dataptr = find_task_data(get_current_task());
	data = *dataptr;
	if (data == NULL) return;
	if (data->obj == NULL) return;
	color = (now/period) % data->ncolors;
	for (i = 0; i < data->np; ++i)
		set_poly_color(data->obj, i, data->colors[(color+i) % data->ncolors]);
	world_changed++;
	break;
     default:
	break;
   }
}


typedef struct {
	SEGMENT *seg;
	long rx,ry,rz;
} SCULDATA;

extern SEGMENT *find_seg(char *name);

void sculspin(int cmd, char *init, long now, long period)
{
  SCULDATA *data, **dataptr;
  OBJECT *obj;
  char *parms;
  float rx, ry, rz;

  switch (cmd)
    {
      case 0:
	if ((data = malloc(sizeof(SCULDATA))) == NULL) return;
	dataptr = find_task_data(get_current_task());
	*dataptr = data;
	data->rx = data->ry = data->rz = 0;
	if ((parms = strchr(init, ';')) != NULL)
	  {
	    *parms++ = '\0';
	    sscanf(parms, "%f,%f,%f", &rx, &ry, &rz);
	    data->rx = rx * 65536L;
	    data->ry = ry * 65536L;
	    data->rz = rz * 65536L;
	  }
	data->seg = object2segment(find_seg(init));

/*			obj = find_name(objectlist, init);
			if (obj)
				data->seg = get_object_owner(obj); */
			break;
     case 1:
	dataptr = find_task_data(get_current_task());
	data = *dataptr;
	if (data == NULL) return;
	if (data->seg == NULL) return;
	rel_rot_segment(data->seg, data->rx, data->ry, data->rz, RYXZ);
	update_segment(data->seg);
	world_changed++;
	break;
     default:
	break;
   }
}
