/* Code for loading drivers at runtime */

/* Written by Dave Stampe, August 1992 */

// See the driver toolkit for how to build stuff for this.


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <stdlib.h>   /* exit() */
#include <dos.h>
#include <alloc.h>

void *load_driver(char *dfile)
{
	FILE *f;
	long s;
	void *d_mem, *d_ptr;

	f = fopen(dfile,"rb"); /* open driver file */
	if (f == NULL) return NULL;

	fseek(f, 0, SEEK_END); /* find length, get memory */
	s = ftell(f);
	d_mem = (char *) malloc(s+16);
	if (d_mem == NULL)
	{
		fprintf(stderr,"Cannot allocate memory for driver.\n");
		exit(0);
	}/* setup for segment aligned load */

	d_ptr = MK_FP(FP_SEG(d_mem),0);
	fseek(f, FP_OFF(d_mem), SEEK_SET);
	fread(d_mem, 1, s-FP_OFF(d_mem), f);

	fclose(f);

	return d_ptr;
}

extern void *screen_data(void);

unsigned char get_video_driver_version()
	{
	unsigned char *ptr;
	ptr = screen_data();
	if (ptr[22]) return 1;  /* if there's a string there, it's version 1 */
	if (ptr[23] == 0) return 1;  /* if there's all zeros there, it's version 1 */
	return ptr[23];  /* otherwise, the second byte is the version number */
	}
