/* Glove pointer device */

/* Written by Dave Stampe, August 1992 */

// Pointers are an attempt to integrate device support across
// REND386.  Why isn't anyone using them?

// Ported to VR-386 9/1/94 by Dave STampe
// Basically a "wrapper" around SGSPPT.C and the PCDEVICE library

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/

#include <stdio.h>
#include <stdlib.h>    /* atexit() */
#include <dos.h>
#include <conio.h>     /* kbhit() */

#include "vrconst.h"
#include "pointint.h"
#include "vr_api.h"
#include "pcdevice.h"
#include "intmath.h"

/************** INTERNAL GLOVE SETUP ***********/

PDRIVER *glove_device;


/***************** GLOVE POINTER DRIVER *************/

static pconfig glove_pconfig = {
	5*65536L, 5*65536L, -15*65536L, 	/* position res: mm/tick in <16.16>  */
	120, 120, 120, -120, -120, -120, 	/* xyz ranges:                */
	0, -30*65536L, 0,
	0, 0, 0, 120, 11, 120, 			/* some rotation (swing emulation)       */
	320, 200, 				/* mouse emulation limits (writable) */
	P_HASX | P_HASY | P_HASZ | P_HASRY | P_HASSCR |
		P_HASGEST | P_HASFLEX | P_HASKEYS, 		/* databits  */
	P_CENTER | P_SCREEN, 0xFF, 11, 				/* modes, nullkey, flexnum           */
	2, 50, 20, 				/* delay, idelay, reads/sec          */
	P_IS3DG | P_IS3D | P_IS2D, 		/* uses  */
	"Default Powerglove Driver"
};

static glove_data glove_new; /* glove data structure */

#define DEBOUNCE_TIME 8

static setup_glove(void) /* glove initialize (incl. int. system) */
{
	glove_init(1);
	save_screen();
	popmsg("Waiting for glove...");
	tdelay(1000);

	while (!glove_ready())
	  if (kbhit())
	    {
	      getkey();
	      return -3;
	    }
	restore_screen();
	glove_read(&glove_new);
	return 0;
}


static fbend[4] = { 0, 40, 90, 127 }; /* finger flexions      */
static tbbend[4] = { 0, 25, 72, 127 };
static ttbend[4] = { 0, 35, 80, 127 };

pconfig *glove_driver(int op, POINTER *p, int mode)
{
	int ft, fi, fm, fp;

	switch(op)
	{
	case DRIVER_CMD:
	case DRIVER_RESET:
		break;

	case DRIVER_INIT:
		setup_glove();
		break;

	case DRIVER_READ:/* pointer (2DP) read */
		if (mode == P_POINTER)
		{
			if (glove_ready() == 0) return NULL;
			glove_read(&glove_new);
			p->x = glove_new.x;
			p->y = glove_new.y;
			p->z = glove_new.z;
			p->rx = 0;
			p->ry = ((long) glove_new.rot) << 16;
			p->rz = 0;
			p->buttons = 0;
			p->keys = glove_new.keys;

			ft = (glove_new.fingers >> 6) & 3; /* finger joint angles */
			fi = (glove_new.fingers >> 4) & 3;
			fm = (glove_new.fingers >> 2) & 3;
			fp = (glove_new.fingers >> 0) & 3;

			p->flex[0] = tbbend[ft];
			p->flex[1] = ttbend[ft];
			p->flex[2] = p->flex[3] = fbend[fi];
			p->flex[4] = p->flex[5] = fbend[fm];
			p->flex[6] = p->flex[7] = fbend[fp];
			p->flex[8] = p->flex[9] = fbend[fp];

			p->gesture = (gesture_time>DEBOUNCE_TIME)?gesture_type:G_UNKNOWN ;
		}
		else if (mode == P_SCREEN) /* mouse read (640x480) */
		{
			glove_read(&glove_new);
			p->x = scale_16(((long) glove_pconfig.maxsx) << 8, 127, (long)glove_new.x);
			p->y = scale_16(((long) glove_pconfig.maxsy) << 8, 127, -(long)glove_new.y);
			if (p->x < 0) p->x = 0;
			if (p->y < 0) p->y = 0;
			if (p->x > glove_pconfig.maxsx) p->x = glove_pconfig.maxsx;
			if (p->y > glove_pconfig.maxsy) p->y = glove_pconfig.maxsy;
			p->gesture = (gesture_time > DEBOUNCE_TIME) ? gesture_type : G_UNKNOWN;
			p->buttons = (p->gesture == G_FIST) ? 1 : 0;
		}
		break;

	case DRIVER_CHECK:
		break;
	case DRIVER_QUIT:
		break;
	}
	return &glove_pconfig;
}

