/* Handles head tracker init, use */

/* Written by Dave Stampe, 4/1/94 */

// Rewritten, parieal VR-386 port by Dave Stampe, 9/1/94


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <stdlib.h>    /* atexit() */
#include <dos.h>

#include "pointer.h"
#include "vr_api.h"
#include "intmath.h"
#include "splits.h"
#include "pcdevice.h"
#include "segment.h"


static PDRIVER *head_device;

static MATRIX h_recenter, ht_offset, ht_ioffset;

void head_tracker_process(BOOL recenter) /* repositions head based on tracker data */
{
  POINTER hp;
  MATRIX m;
  int c;

  if (!head_device) return;
  c = pointer_read(head_device, &hp); 		/* read tracker */

//  if (recenter) /* use current pos'n as zero */  NOT YET FIXED
//    {
//      std_matrix(m, hp.rx, hp.ry, hp.rz, hp.x, hp.y, hp.z);
//      inverse_matrix(m, h_recenter);
//      matrix_product(ht_ioffset, h_recenter, h_recenter);
//      c = PNEW_POS;
//    }

  if (c & (PNEW_POS | PNEW_ROT)) /* compute new hpos */
    {
      multi_matrix(m, hp.rx, hp.ry, hp.rz, hp.x, hp.y, hp.z, RYXZ); // ht to maatrix
//      matrix_product(h_recenter, m, m);
      matrix_product(m, ht_offset, m);			// translate to head coords
      abs_mat_segment(object2segment(head_seg), m);	// load up segment
      position_changed++;                               // redraw needed
    }                               // update occurs with redraw
  return;
}


void htrack_quit()
{
  pointer_quit(head_device);
}


PDRIVER *init_head_device(char *dfname, POSE *hdo)
{
  MATRIX m;
  PDRIVER *p;
  POINTER pt;

  p = pointer_init(P_IS6H, dfname); /* setup glove device TEST */
  if (p == NULL) return NULL;

  init_pointer(&pt); 		/* so that defaults are OK */

			 /* use real-world scaling output*/
  pointer_abscale(p, 65536L, 65536L, 65536L, 65536L, 65536L, 65536L);

  pointer_read(p, &pt);
  pointer_read(p, &pt); /* save current position */

  head_device = p;
  atexit(htrack_quit);

  identity_matrix(h_recenter);		// no recenter

  std_matrix(m,hdo->rx,hdo->ry,hdo->rz,hdo->x,hdo->y,hdo->z);   // tracker->head xform

  matrix_copy(m, ht_offset);
//  matrix_copy(m, h_recenter);

  inverse_matrix(m, ht_ioffset);
  inverse_matrix(m, h_recenter);
  head_tracker_process(1);		// finish by setting up system
  return p;
}

