// new LIGHTING support routines for VR-386
// 29/12/93 by Dave Stampe



/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <stdlib.h>  /* for atol(), only for debugging! */
#include <dos.h>
#include <alloc.h>

#include "vr_api.h"
#include "segment.h"
#include "intmath.h"


	// create, initialize a light and its segment
LIGHT *create_light(OBJECT *parent, WORD type, WORD intensity)
{
  SEGMENT *p = object2segment(parent);
  SEGMENT *s;
  LIGHT *l = calloc(sizeof(LIGHT),1);
  if(!l) return NULL;
  s = new_seg(p);
  if(!s)
    {
      free(l);
      return NULL;
    }
  register_system_segment(s);
  l->seg = s;
  l->type = type;
  l->intensity = intensity;
  return l;
}

	// destroy a light and its segment
void destroy_light(LIGHT *l)
{
  detach_segment(l->seg,0);
  destroy_segment(l->seg);
  free(l);
}

	// returns light type
WORD get_light_type(LIGHT *l)
{
  return l->type;
}

	// returns light intensity
WORD get_light_intensity(LIGHT *l)
{
  return l->intensity;
}

	// sets intensity of light
void set_light_intensity(LIGHT *l, WORD i)
{
  l->intensity = i;
}

	// sets light type
void set_light_type(LIGHT *l, WORD t)
{
  l->type = t;
}

	// attaches light to segment
BOOL attach_light(LIGHT *l, OBJECT *s, BOOL preserve)
{
  attach_object(l->seg, s, preserve);
  return TRUE;
}

	// detaches light from segment
BOOL detach_light(LIGHT *l, BOOL preserve)
{
  detach_segment(l->seg, preserve);
  return TRUE;
}

	// change angle of a spotlight
BOOL rotate_spotlight(LIGHT *l, POSE *p)
{
  seg_setpose(l->seg, p);
  full_update_segment(l->seg);
  l->type = SPOT_LIGHT;
  return TRUE;
}

	// change position of point source
BOOL position_pointlight(LIGHT *l, POSE *p)
{
  seg_setpose(l->seg, p);
  full_update_segment(l->seg);
  l->type = POINT_LIGHT;
  return TRUE;
}

	// change pos/rot of light source
BOOL set_light_pose(LIGHT *l, POSE *p)
{
  seg_setpose(l->seg, p);
  full_update_segment(l->seg);
  return TRUE;
}

	// get local position/angle of light
void get_light_localpose(LIGHT *l, POSE *p)
{
  seg_getpose(l->seg, p);
}

	// get world position/angle of light
void get_light_worldpose(LIGHT *l, POSE *p)
{
  seg_getworldpose(l->seg, p);
}

	//  fetch light data for computing
WORD get_light_data(LIGHT *l, COORD *xp, COORD *yp, COORD *zp, WORD *intensity)
{
  *intensity = l->intensity;
  if(l->type==POINT_LIGHT)
    {
      seg_getposxyz(l->seg, xp, yp, zp);
    }
  else if(l->type==SPOT_LIGHT)
    {
      MATRIX *m = get_seg_pmatrix(l->seg);
      if(xp) *xp = (*m)[0][2]; // get the Z column as the vector
      if(yp) *yp = (*m)[1][2];
      if(zp) *zp = (*m)[2][2];
    }
  return l->type;
}
















