// This is the main program of the VR-386 port of
// the REND386 V5.0 demo program.  It may be used as
// a template for your own software.  Some changed
// to INIT.C may also be needed.

// 9/1/94 by Dave Stampe

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>   /* toupper() */
#include <string.h>
#include <mem.h>     /* memmove() */
#include <dos.h>
#include <alloc.h>   /* coreleft */

#include "pointer.h"
#include "vr_api.h"
#include "intmath.h"
#include "pcdevice.h"
#include "splits.h"
#include "oldtasks.h"
#include "vrconst.h"

#include "f3dkitd.h"  /* for load_dac_colors() */


BOOL running = 0;
BOOL in_graphics = 0;

/************* STEREOSCOPIC DATA ***************/

extern STEREO default_stereo;
extern WORD stereo_type;

/************ OPTIONS FLAGS ***************/

extern int use_ht;
extern int have_ptr;
extern int have_glove;

extern int use_BW;
extern int swap_eyes;
extern int use_glove;

TASK *tasklist = NULL;



int mouse_nav = 0;	// use mouse as joystick
extern use_keyjoy;	// use keys as joystick
int flymode = 0;

// some options

int animatemode = 1;
int do_horizon = 1;
int show_location = 1; /* if set, we display the current location on-screen */
int show_compass = 1; /* if set, we display the 3-D compass on-screen */
int show_framerate = 1; /* if set, we display the frames/second rate */
int do_screen_clear = 1; /* by default, we clear the screen on each frame */
int use_frame = 0; /* if set, draw a "frame" */



// some test values

unsigned hcolors[20] = { 0xaf, 0xae, 0xad, 0xac, 0x79, 0x7a, 0x7b, 0x7c };

test_h()
{
 set_horizon(8, hcolors, 48);
}


/********** CLOSE PROGRAM ***********/

static char *closing_msg[] = {
	"",
	NULL };


void wrap(void) /* end program */
{
	int i;
	exit_handler();
	for (i = 0; closing_msg[i]; ++i)
	   fprintf(stderr, "%s\n", closing_msg[i]);
}


/************** MAIN PROGRAM ***************/


refresh_display()
{
  update_body_links();
  screen_refresh(current_camera);

  position_changed = 0;
  world_changed = 0;
  display_changed = 0;
}



extern char *title[];   // world title display (3 seconds)

void main(int argc, char *argv[])
{
  int i;
  long t;

  if (getenv("REND386"))                     // start up path
	strcpy(loadpath, getenv("REND386"));

  title_screen();		      // title screen

  preload_initialize(argc, argv);

  create_default_segs(); 		/* for animations */
  create_default_lights();              // for world loading

  read_input_files(argc, argv);     // get any files to be loaded

  atexit(wrap);

  load_memory_report();

  wait_for_title();

  video_initialize();

  device_initialize();

  test_h();  // TEST MULTI HORIZON

  if (title[0])
    {
      refresh_display();
      poptext(title);
      get_response(0);
      t = current_time();
      while ((current_time()-t) < 3000)
	{
	  if (get_response(0)) break;
	}
      while (kbhit()) getch();
      refresh_display();
    }

  running = 1;
  while (running)    // THE EXECUTE LOOP
    {
		// process any keys (do BEFORE joystick_process)
       key_process();
		// mouse joy device mode
       joy_set_mode( ((mouse_nav!=0)?MJOY_ENABLE:0) | ((flymode!=0)?MJOY_VELOCITY:0) );
		// navigate
       joystick_process();
		// menu, object selection: do AFTER joy (mouse counters)
       mouse_process();
		// head tracker
       if (use_ht) head_tracker_process(0);
		// gloves, 3D pointers
       if (use_glove)
	 {
	   if(!have_ptr) glove_process();
	   else pointer_process();
	 }
		// animation
       if (animatemode==-1) animatemode = 0; /* single step OFF */
       if (animatemode)
	 {
	   run_tasks(tasklist);
	   do_animations();
	 }
		// update screen if needed
       if (position_changed || display_changed || world_changed)
		 refresh_display();
     }
}

