// Initialization routines for VR-386 demo program.
// You may want to simplify these for your own code,
// especially if you're not supporting all devices

// For VR-386 by Dave Stampe, 9/1/94

// THIS IS FOR THE MINI-PROGRAM DEMO


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>   /* toupper() */
#include <string.h>
#include <mem.h>     /* memmove() */
#include <dos.h>
#include <alloc.h>   /* coreleft */

#include "config.h"
#include "pointer.h"
#include "vr_api.h"
#include "intmath.h"
#include "pcdevice.h"
#include "splits.h"
#include "renderer.h"   // setup_render()
#include "xmem.h"

#include "f3dkitd.h"  /* for load_dac_colors() */


extern unsigned _stklen = 10000; /* need lots of stack for recursion */


/************ SYSTEM DATA **************/

WORD position_changed = 0;   // reasons to refresh screen
WORD display_changed = 1;
WORD world_changed = 1;


/************* DRIVER INFORMATION **************/

char swdname[40] = "sega";
char mdname[40] = "mouse";

PDRIVER *cursor_device = NULL; /* primary mouse device   */
PDRIVER *menu_device = NULL; /* secondary mouse device */

int manip_2D_avail = 0; /* can do mouse manipulation */

// KEEP AROUND FOR CONFIG LOAD, EVVEN THOUGH NOT USED

char gpdname[40] = "pglove";
char gpcursor[40] = "hand.fig";
POSE ptr_scale = { 65536L,65536L,3*65536L,65536L,65536L,65536L};
int have_glove = 0;
int have_ptr = 0;

char hdname[40] = "none";
POSE hd_offset = ZERO_POSE;
int use_ht = 0;

int use_keyjoy = 0;	// use keys as joystick

/************* STEREOSCOPIC DATA ***************/

extern STEREO default_stereo;
extern WORD stereo_type;

/************ OPTIONS FLAGS ***************/

int use_BW = 0;
int swap_eyes = 0;
int use_glove = 0;

/************ MISC. COMMUNICTION *************/

long emmrequest = 0;	// nonzero if EMM request: number of K

long originalmem,aftervideomem,afterloadmem;

void *temp_mem = NULL; /* points to area to be used for temp storage */
long temp_size = 0;


FILE *log_file = NULL;


/************** VIDEO DRIVER *************/


int npalette = 0; /* non-zero if we have a palette loaded */
unsigned char palette[256*3];

extern struct Screeninfo *screeninfo;

char vdname[40] = "vd256.rvd";
int vdmode = 0x14;
int vd_loaded = 0;

void *v_driver_pointer = NULL;

void load_video_driver(char *dfile)
{
  v_driver_pointer = load_driver(dfile);
  if (v_driver_pointer == NULL)
   {
      errprintf("Cannot read video driver %s\n", dfile);
      exit(0);
    }
  screeninfo = screen_data();
}


/************ OPTIONS SCAN **********/

static int file_arg_index[10] = {0,0,0,0,0,0,0,0,0,0};

	// get cmd line options, loads cfg file
	// also marks files on cmd line for loading
void read_configuration(int argc, char *argv[])
{
  int i;
  int fp = 0;
  FILE *in;
  char *fname;
  char *config_file_name = "vr386.cfg";

  if(argc>0)	// any args?
    {
      for (i=1; i < argc; i++)
	{
	  if (argv[i][0] == '/' || argv[i][0] == '-')
	    {
	      switch(toupper(argv[i][1]))
		{
		  case 'L':	/* log file */
		    {
		      char *lf;
		      if (argv[i][2]) lf = &argv[i][2];
		      else lf = argv[++i];
		      log_file = fopen(lf, "w");
		      if (log_file == NULL)
			{
			  errprintf("Could not open log file '%s'\n", lf);
			  exit(2);
			}
		    } break;

		  case 'M':	/* disable MS mouse */
		    mdname[0] = 0;
		    break;

		  case 'R':/* swap eyes on Sega driver */
		    swap_eyes = 1;
		    break;

		  case 'E':	/* set eye spacing OR EMM on */
		    if(toupper(argv[i][2])=='M')
		      {
			if(isdigit(argv[i+1][0]))
			emmrequest = atol(argv[++i]);
			else emmrequest = 4000;
			atexit(resetEMMalloc);
			if(!initEMMalloc(emmrequest>>4))
			   emmrequest = 0;	// clear flag if failure
			break;
		      }
		    break;

		  case 'X':/* turn on stereo */
		    stereo_type = SWITCHED;
		    break;

		  case '1':/* com 1 for SEGA */
		    select_sega_port(0x3FC);
		    break;

		  case '2':/* com 2 for SEGA */
		    select_sega_port(0x2FC);
		    break;

		  case 'G':/* enable glove */
		    use_glove = 1;
		    if (!have_ptr) have_glove = 1;
		    break;

		  case 'H':/* enable head tracker */
		    use_ht = 1;
		    break;

		  case 'B':/* force all colors to monochrome */
		    use_BW = 1;
		    break;

		  case 'K':/* turn on key monitor for joy-keys */
		    use_keyjoy++;
		    init_key_monitor();
		    break;

		  case 'C':	// config file name
		    config_file_name = &(argv[++i][0]);
		    break;
		}
	    }
	  else file_arg_index[fp++] = i;    // record for later loading
	}
    }

  if ((in = fopen(config_file_name, "r")) == NULL)
    errprintf("Note -- config file '%s' not found; using defaults.\n", config_file_name);
  else
    {
      read_config_file(in);
      fclose(in);
    }
}


void read_input_files(int argc, char *argv[])
{
  int i;
  FILE *in;
  char *fname;
  OBJECT *obj;

  i = 0;
  while(file_arg_index[i])
    {
      fname = fix_fname(argv[file_arg_index[i]]);
      if ((in = fopen(fname, "r")) == NULL)
	 errprintf("Could not open '%s'\n", fname);
      else if (strstr(fname,".plg")) /* check if plg or fig file */
	{
	  POSE p = ZERO_POSE;

	  while ((obj = load_plg_object(in, &p, 1, 1, 1, 0)) != NULL)
	    {
	      if (make_fixed_object_moveable(obj,NULL) == NULL)
		 errprintf("Warning: out of memory while loading an object\n");
	      else
		{
		  update_object(obj);	// adds to world if not in it
		  add_object_to_world(obj);
		}
	    }
	  if (plg_error(NULL))
	    {
	      errprintf("%s in file %s\n", plg_error(NULL), fname);
	      getkey();
	    }
	}
      else if (strstr(fname,".fig")) /* check if plg or fig file */
	{
	  obj = load_figure_as_object(in, default_objlist, NULL, 0, 1, 1, 1);
	  if (obj)
	    {
	      add_objlist_to_world(default_objlist);
	      update_object(obj);
	     }
	  if (seg_error(NULL))
	   {
	     errprintf("%s in file %s\n", seg_error(NULL), fname);
	   }
	}       // NO READ WORLD FOR MINI DEMO
     fclose(in);
     i++;
   }
}


/********** CLOSE PROGRAM ***********/

void exit_handler(void) /* end program */
{
  int i;

  if (in_graphics) exit_graphics();
  in_graphics = 0;
  reset_render();
  if (log_file) fclose(log_file);
}


/************** MAIN PROGRAM ***************/

extern void move_rep(OBJECT *o);   // the default renderer object update handler

void preload_initialize(int argc, char *argv[])
{
  originalmem = farcoreleft();		// initialize RENDERER
  temp_mem = setup_render(63,1500);      /* # of K, # of polys */
  temp_size = 63000L;

  set_renderer_update_handler(move_rep);  // MOTION HANDLERS
  set_move_handler(split_move_handler);

  read_configuration(argc, argv);       // configure system

		/* preload video driver to set defaults */
#ifdef LOAD_VIDEO_DRIVER
  load_video_driver(vdname);
#endif
  aftervideomem = farcoreleft();

  screeninfo = screen_data();		// pre-world-load setup data
  preset_default_colors();              // set up colors for

  create_default_world();

  init_body_links();			// create cameras, body
}



void load_memory_report()
{
  afterloadmem = farcoreleft();     // memory report
  if(emmrequest)
    {
      extern long alloccount;
      fprintf(stderr,"EMM used: %ld in %ld allocs,  EMM available: %ld  \n",
			    EMMheapused(), alloccount, EMMheapsize() );
    }

  fprintf(stderr,"DOS memory:\n\t Renderer = %ld,\n\t World = %ld,\n\t Total = %ld;  %ld free\n",
			originalmem - aftervideomem,
			aftervideomem - afterloadmem,
			originalmem - afterloadmem , afterloadmem   );
}


void video_initialize()
{
  enter_graphics(vdmode, use_BW);    // GRAPHICS INIT
  in_graphics++;
  compute_camera_factors(default_camera);
  if (npalette)
	load_DAC_colors(palette, screeninfo->colors, use_BW,0);
  reset_screens();
}


void device_initialize()
{
  PDRIVER *dm;

			// system timer startup
  init_timer(0,NULL);	// uses default or driver speeds


			// alternate-frame stero driver start
			// may take over timer
  if(stereo_type==SWITCHED) init_switch_driver(swdname);

  add_joy_device("joystick");   	// navigation devices
  add_joy_device("keys");
  add_joy_device("mjoy");
  if(use_keyjoy)
     add_joy_device("keymon");
					 // head tracker startup
  if (stricmp(hdname,"none") && use_ht)
      if(!init_head_device(hdname, &hd_offset)) use_ht = 0;

  if ((dm=mouseptr_init(mdname))!=NULL)  // mouse/cursor initialize
    {
      cursor_enable(TRUE);	// cursor available
      cursor_show();
      manip_2D_avail++;         // and can be used for manipulation
    }
  cursor_device = dm;		// mouse for object selection
  menu_device = dm;             // mouse for menu interface

// NO GLOVE FOR MINI DEMO
}

