/* 2D pointer device (built-in) for Microsoft Mouse*/

// Pointers are an attempt to integrate device support across
// REND386.  Why isn't anyone using them?

/* Original written by Dave Stampe, Aug. 1992 */


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <dos.h>
#include <bios.h>

#include "pointint.h"
#include "vr_api.h"

/************** INTERNAL MOUSE SETUP ***********/

static PDRIVER *mouse_device;

static void mouseptr_quit()
{
  pointer_quit(mouse_device);
}


PDRIVER *mouseptr_init(char *mname)
{
 PDRIVER *p;
 POINTER x;

 p = pointer_init(P_IS2DP, mname); /* setup mouse device */
 if (p==NULL) return NULL;

 init_pointer(&x); /* so that defaults are OK */
 pointer_tscale(p, 1000, 1000, 1000); /* scale mouse */
 set_mouse_limits(p, screeninfo->xmax, screeninfo->ymax);
 pointer_read(p, &x);
 pointer_read(p, &x); /* save current position */
 mouse_read(p, NULL, NULL, NULL);

 mouse_device = p;
 atexit(mouseptr_quit);

 return p;
}



/***************** MOUSE POINTER DRIVER *************/

pconfig mouse_pconfig = {
	65536L, 65536L, 65536L, /* position res: mm/tick in <16.16>  */
	320, 200, 200, -320, -200, -200, /* xyz ranges:                */
	0, 0, 0, 0, 0, 0, 0, 0, 0, /* no rotation                       */
	640, 480, /* mouse emulation limits (writable) */
	P_HASB1 | P_HASB2 | P_HASX | P_HASY | P_HASZ | P_HASSCR, /* databits  */
	P_CENTER | P_SCREEN, 0, 0, /* modes, nullkey, flexnum           */
	1, 10, 60, /* delay, idelay, reads/sec          */
	P_IS2DP | P_IS2D, /* uses  */
	"Default Mouse Driver"
};


static mtype; /* if == P_IS2D, don't map Z with buttons */
static x_acc, y_acc, z_acc, xs_acc, ys_acc;

pconfig *mouse_driver(int op, POINTER *p, int mode)
{
 union REGS r;
 int type = FP_OFF(p); /* way to get integer arg. */

 switch(op)
  {
   case DRIVER_CMD:
    if (!(type & P_CENTER)) break;
    if (type & P_SCREEN)
     {
      xs_acc = mouse_pconfig.maxsx >> 1;
      ys_acc = mouse_pconfig.maxsy >> 1;
     }
    if (type & P_POINTER)
     {
      x_acc = y_acc = z_acc = 0;
     }
    break;
   case DRIVER_INIT:
   case DRIVER_RESET:
    r.x.ax = 0;
    int86(0x33, &r, &r);
    if (r.x.ax == 0) return NULL;
    x_acc = y_acc = z_acc = 0;
    xs_acc = mouse_pconfig.maxsx>>1;
    ys_acc = mouse_pconfig.maxsy>>1;
    break;

   case DRIVER_READ:/* pointer (2DP) read */
    if (mode == P_POINTER)
     {
      r.x.ax = 3; /* read button status */
      int86(0x33, &r, &r);
      p->buttons = r.x.bx;
      r.x.ax = 11; /* read motion counters */
      int86(0x33, &r, &r);
      x_acc += ((int) r.x.cx);
      if (p->buttons & 0x02)
       {
	z_acc -= ((int) r.x.dx);
	p->buttons &= 0x01;
       }
      else
       y_acc -= ((int) r.x.dx);
       p->x = x_acc;
       p->y = y_acc;
       p->z = z_acc;
     }
    else if (mode == P_SCREEN) /* mouse read (640x480) */
     {
      r.x.ax = 3; /* read button status */
      int86(0x33, &r, &r);
      p->buttons = r.x.bx;
      r.x.ax = 11; /* read motion counters */
      int86(0x33, &r, &r);
      xs_acc += ((int) r.x.cx);
      ys_acc += ((int) r.x.dx);
      if (xs_acc < 0) xs_acc = 0;
      if (ys_acc < 0) ys_acc = 0;
      if (xs_acc > mouse_pconfig.maxsx) xs_acc = mouse_pconfig.maxsx;
      if (ys_acc > mouse_pconfig.maxsy) ys_acc = mouse_pconfig.maxsy;
      p->x = xs_acc;
      p->y = ys_acc;
     }
    break;

   case DRIVER_CHECK:
    break;
   case DRIVER_QUIT:
    break;
  }
 return &mouse_pconfig;
}

