// private declarations for renderer pipeline

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



#include "vr_ctypes.h"

// from HORMATH.ASM

	// computes if point on screen is above or below horizon
	// used to determine how to draw horizon
extern int above_horizon(long x, long y, VIEW *v, long offset);

	// computes y coord of horizon given x coordinarte
extern long y_horizon(long x, VIEW *v, long offset);

	// computes y coord of horizon given x coordinarte
extern long x_horizon(long y, VIEW *v, long offset);

// from horizon.c

// 2-color horizon: if sky and ground color are same,
// just clears window in one pass
// these colors are usually direct entries into the pallette

	// sets sky color of 2-color horizon
extern void set_skycolor(int color);

	// get ground clor of 2-color horizon
extern void set_groundcolor(int color);


/** EXTERNAL HORIZON TYPE SETUP **/

// args: ncolor = 0 for no clear (i.e if you clear full page before)
//       ncolor = 1 for solid clear to skycolor, or skycolor=groundcolor
//       ncolor = 2 for normal horizon, or skycolor<>groundcolor
//       ncolor > 2 for banded horizon with array of colors from palette
//	 leave bandsize 0 (unchanged), or use 64 for best size

// an example colorset: { 0xaf, 0xae, 0xad, 0xac, 0x79, 0x7a, 0x7b, 0x7c }

extern void set_horizon(int ncolors, int colors[16], int bandsize);

/** DRAW HORIZON/CLEAR WINDOW CALL ***/

extern void horizon(VIEW *v, int page);    // clear window or draw horizon

// from LIGHTING.ASM

	/* compute vector from light source to surface  */
	/* find dot product, normalize by vector length */
	/* returns -128<light<128 (signed 8-bit)        */
	/* args: ligh characteristics, poly normal, point on poly */
	/* point on poly is 0,0,0 for spotlight 	*/
	/* takes about 200 clocks!			*/
extern int light_cosine(long nx, long ny, long nz,
			 long vx, long vy, long vz,
			 long lx, long ly, long lz );

// from VIEWREND.ASM


	// ASSEMBLER: copies viewport data to statics
	// viewport must have been processed by
	// initialize_screen_factors() in the past,
	// and then viewpoint can be changed with
	// fast_view_factors() or matrix_view_factors

	/* copy viewport data to fast access area */
	/* to prepare renderer to draw a view     */
	/* do after viewpoint or look angle has changed */
extern void render_set_view(VIEW *v);


	/* compute screen and viewport factors.  These stay constant   */
	/* over eye point changes.  Call this to initialize a viewport */
	/* and after the view parameters such as zoom or stereo change */
extern void initialize_screen_factors(VIEW *v);

// from OBJREND.ASM

	// quicksort of poly/object array of DSORT <pointer,depth>
	// sorts into descending order.  Fastest for lots of polys
extern void qsort_dsort(DSORT far *first, DSORT far *last);

	// insertion sort of poly/object array of DSORT <pointer,depth>
	// faster than quicksort if less than 16 items (i.e with splits)
	// sorts in descending order
extern void insertion_dsort(DSORT far *first, DSORT far *last);

	// determines if any part of object's bounding sphere
	// is within view volume.  Very fast.  It returns
	// the prescaled (x4) depth of the object center for sorting.
	// if not visible, returns OUT_OF_VIEW
#define OUT_OF_VIEW 0x80000000L	// returned if we can't see object
extern long obj_clip_by_volume(VISOBJ *obj);

	// determine width of bounding sphere of object
	// on the screen in pixels: used to decide which
	// representation to use.
	// only use if object has passed preclip!
extern long compute_obj_screen_size(VISOBJ *obj, long center_z);

	// prepares object for rendering by clearing its
	// caching flags and pointers
	// a representation must be current!
extern void prerender_clear_object(VISOBJ *obj);

// from XYCLIP.ASM

	// optimized semi-recursive Sutherland-Hodgeman clipper
	// XY clips screen coordinates of an array of pointers to NVERTEX
	// (renderer vertex copies), and stores pointers to output vertices
	// in a new array.  May create new, clipped vertex copies
	// returns number of vertex pointers placed in array
extern int XY_clip_array(NVERTEX **src, NVERTEX **dest, int count);

// from POLYPROC.ASM

	// transforms coordinates of vertex to X, Y camera coords.
	// It will re-use previous calculations and vertices if possible
	// (i.e when several polys share a vertex).  It will create a
	// new copy of the vertex if transformation is needed.
extern NVERTEX *xy_transform(VERTEX *v);

	// final processing for vertex after XY transform. Figure the
	// perspective and XY screen positions and XY poly outcodes
	// returns the outcodes
extern int z_output(NVERTEX *nv);

	// convert vertex to determine camera Z coordinate.  Fills in
	// the outcode field and can re-use previously transformed
	// results from other polys.  Returns Z outcode
extern int z_convert_vertex(VERTEX *vtx);

	// returns sign of visibility dot product of poly normal
	// with line connecting viewpoint to vertex 0.  Used for
	// BSP sorting and backface removal
extern int is_poly_facing(POLY *p);

	// creates new vertex from hither plane intercept of edge
	// between two vertices.  Always allocates new vertex
	// we don't clip yon plane at all, just discard polys
	// that are too far away
extern NVERTEX *z_hither_clip(NVERTEX *v1, NVERTEX *v2);

	// finds the average depth of a ploy by going therough
	// the list of NVERTEX pointers for the poly.  THe
	// returned depth is prescaled (x4)
extern long average_nvertex_depth(NVERTEX **nvp, int ncount);

	// same as average_nvertex_depth, but returns deepest depth
extern long deepest_nvertex_depth(NVERTEX **nvp, int ncount);


// from POLYOUT.ASM

	// unpack poly's vertices to array, in X,Y pair order (CCW)
	// vertices order can be reversed for drawing to the screen
	// with X (xor) Y mirroring.  De-prescales XY coords.
	// returns number of vertices unpacked
extern int unpack_poly_vertices(NPOLY *poly, int *vtxarray, int direction);

	// given array of screen vertices from unpack_poly_vertices()
	// checks to see if point (x,y) is inside of poly.
	// returns -1 for point not in poly, else 0
extern int monitor_test_poly(int x, int y, int n, int *array);


// from RENDCORE.C

// no routines from rendcore.c need to be declared in this private file
// except for the use of HORIZON.C.


// external renderer poly interface

extern void render_ext_poly(int npoints, int xv[20], int yv[20], unsigned color);


