// Dave Stampe, 9/1/94
// old SEGMENT f'ns, not part of API

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



extern SEGMENT *new_seg(SEGMENT *parent);
extern void seg_set_object(SEGMENT *s, VISOBJ *obj);
extern void seg_reset_object(SEGMENT *s, VISOBJ *obj);
extern void *seg_get_object(SEGMENT *s);
extern char *seg_getname(SEGMENT *s);
extern void seg_setname(SEGMENT *s, char *name);
extern void seg_getposang(SEGMENT *s, long *rx, long *ry, long *rz);
extern void seg_getjointang(SEGMENT *s, long *rx, long *ry, long *rz);
extern void seg_getposxyz(SEGMENT *s, long *x, long *y, long *z);
extern void seg_getjointxyz(SEGMENT *s, long *x, long *y, long *z);
extern void abs_move_segment(SEGMENT *s, long tx, long ty, long tz);
extern void rel_move_segment(SEGMENT *s, long tx, long ty, long tz);
extern void abs_mat_segment(SEGMENT *s, MATRIX m);
extern void rel_mat_segment(SEGMENT *s, MATRIX m);
extern void abs_rotmat_segment(SEGMENT *s, MATRIX m);
extern void rel_rotmat_segment(SEGMENT *s, MATRIX m);
extern void abs_rot_segment(SEGMENT *s, long rx, long ry, long rz, int order);
extern void rel_rot_segment(SEGMENT *s, long rx, long ry, long rz, int order);
extern void move_rep(OBJECT *obj); /* move current rep of object  */
extern void set_move_handler(void (*move_handler_ptr)());
extern void full_update_segment(SEGMENT *seg);
extern void update_segment(SEGMENT *seg); /* scan till update needed */
extern SEGMENT *find_root_segment(SEGMENT *s);
extern SEGMENT *parent_segment(SEGMENT *s);
extern SEGMENT *child_segment(SEGMENT *s);
extern SEGMENT *sibling_segment(SEGMENT *s);
extern MATRIX *get_seg_jmatrix(SEGMENT *s);
extern MATRIX *get_seg_pmatrix(SEGMENT *s);
extern void detach_segment(SEGMENT *s, BOOL preserve);    /* assumes segment is updated! */
extern void attach_segment(SEGMENT *s, SEGMENT *to, BOOL preserve); /* assumes parent is updated! */
extern SEGMENT *copy_segment(SEGMENT *s, long dx, long dy, long dz, void *(*copy_fn)());

extern SEGMENT *get_root_segment(SEGMENT *s);
extern void seg_getrxyz(SEGMENT *s, long *rx, long *ry, long *rz);
extern int seg_get_flags(SEGMENT *s);
extern void seg_set_flags(SEGMENT *s, int f);

//// EXTENSIONS TO SEGMENTS FOR POSE

extern void seg_reset_object(SEGMENT *s, VISOBJ *obj);
	// gets cached joint pos/angle
void seg_getpose(SEGMENT *s, POSE *p);
	// get joint pose, computes angle from matrix
void seg_getmatpose(SEGMENT *s, POSE *p);
	// get position in world after transforms
void seg_getworldpose(SEGMENT *s, POSE *p);
	// set the joint position from the pose
void seg_setpose(SEGMENT *s, POSE *p);
	// attach segments, preserve world position if desired
void attach_segment(SEGMENT *s, SEGMENT *to, BOOL preserve);
	// detach segment, preserve world position if desired
void detach_segment(SEGMENT *s, BOOL preserve);
	// deletes segment, preserves children
void destroy_segment (SEGMENT *s);
	// marks segment as protected from recursive deletes
void register_system_segment(SEGMENT *s);
	// finds, refreshes root field
SEGMENT *find_root_segment(SEGMENT *s);    // try to do without
	// returns root field
SEGMENT *get_root_segment(SEGMENT *s);

OBJECT *find_segment_by_name(OBJECT *obj, char *name);

void mark_object_invisible(OBJECT *obj);
void mark_object_visible(OBJECT *obj);

void remove_from_segment_update_list(SEGMENT *seg);

