/* Splitting-tree structures: theory by Dave Stampe, initial
   implementation by Bernie Roehl */

// HARDLY NEEDED NOW since code is now properly organized
// This could be used for debugging, include before any
// other file

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



#ifndef SPLITDEF
typedef struct _split SPLIT;

struct _split {
	long x, y, z;    /* a point in the splitting plane */
	long nx, ny, nz; /* the normal vector to the splitting plane */
	OBJLIST *olist;  /* list of objects making up this split */
	unsigned flags;
	char left_type;  /* indicates what the left pointer points to */
	char right_type; /* indicates what the right pointer points to */
#define ISSPLIT    0
#define ISAREA     1
#define ISOBJLIST  2
	void *left, *right; /* can point to a split, an area or an objlists */
	};

#define SPLITDEF 1
#endif

#ifndef AREADEF
typedef struct _area AREA;
#endif

typedef struct _area_ref AREA_REF; /* element in a list of area pointers */

struct _area_ref {
	AREA *area;
	AREA_REF *next;
	};

#ifndef AREADEF
struct _area {
	long floor_a, floor_b, floor_c, floor_d; /* ax + y + cx + d = 0 */
	long ceiling_a, ceiling_b, ceiling_c, ceiling_d; /* ax + y + cx + d = 0 */
	void (*fn)(AREA *);
	AREA_REF *visfrom;
	int has_tree : 1;
	void *ptr;
	char *name;
	};
#define AREADEF 1
#endif

/* End of splitdef.h */
