;/* Splitting-tree structures for assembly */

;/* Assembly-language structures*/
; by Dave Stampe, Dec. 93 */

;/* Copyright 1993 by Dave Stampe and Bernie Roehl.
;   May be freely used to write software for release into the public domain;
;   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
;   for permission to incorporate any part of this software into their
;   products!
; */



;struct _split {
;	long x, y, z;    /* a point in the splitting plane */
;	long nx, ny, nz; /* the normal vector to the splitting plane */
;	OBJLIST *olist;  /* list of objects making up this split */
;	unsigned flags;
;	char left_type;  /* indicates what the left pointer points to */
;	char right_type; /* indicates what the right pointer points to */
;#define ISSPLIT    0
;#define ISAREA     1
;#define ISOBJLIST  2
;	void *left, *right; /* can point to a split, an area or an objlists */
;	};

SPLIT STRUC
split_x 	dd ?
split_y 	dd ?
split_z 	dd ?

split_nx	dd ?
split_ny	dd ?
split_nz	dd ?

split_olistptr 	dd ?
split_flags	dw ?
split_ltype	db ?
split_rtype	db ?

split_leftptr 	dd ?
split_rightptr 	dd ?
SPLIT ENDS

ISSPLIT equ   0
ISAREA  equ   1
ISOBJLIST equ 2


;struct _area {
;	long floor_a, floor_b, floor_c, floor_d; /* ax + y + cx + d = 0 */
;	long ceiling_a, ceiling_b, ceiling_c, ceiling_d; /* ax + y + cx + d = 0 */
;	void (*fn)(AREA *);
;	AREA_REF *visfrom;
;	int has_tree : 1;
;	void *ptr;
;	char *name;
;	};

AREA STRUC
area_floora	dd ?
area_floorb	dd ?
area_floorc	dd ?
area_floord	dd ?

area_ceila	dd ?
area_ceilb	dd ?
area_ceilc	dd ?
area_ceild	dd ?

area_fnptr 	dd ?
area_visptr	dd ?
area_hastree	dw ?
area_ptr 	dd ?
area_nameptr 	dd ?
AREA ENDS

