/* Very simple, non-preemptive, "multitasking" system
   with round-robin scheduling */

/* Originally Written by Bernie Roehl, June 1992 */

// PORTED TO vr-386 api BY dAVE sTAMPE, 9/1/94

// This code is old now: animation support will be much better
// usingg STATMACH.C and new functions in the pipeline

// actually does a simple, non-speed-related update betweeen
// frame draws.  All new routines will be speed-independant

// OLD OLD CODE: NOT REALLY UPDATED FOR API.
// USE AT OWN RISK!  TASKS WILL CHANGE IN FUTURE API RELEASES!


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



#include <stdio.h>
#include <alloc.h>  /* malloc() */

#include "vr_api.h"
#include "segment.h"
#include "wparse.h"

typedef struct _task TASK;

struct _task {
	void (*fn)(int cmd, char *msg, long now, long period);
	void *data;
	long period, lastran, wakeup;
	TASK *next;
};

static TASK *current_task = NULL;

TASK *get_current_task()
{
  return current_task;
}

TASK *add_task(TASK **tasklist,
	void (*fn)(int cmd, char *init, long now, long period),
	long period, void *param)
{
  TASK *t;
  if ((t = malloc(sizeof(TASK))) == NULL) return NULL;
  t->fn = fn;
  t->data = NULL;
  t->period = period;
  t->lastran = 0L;
  t->wakeup = current_time();
  t->next = *tasklist;
  current_task = *tasklist = t;
  if (fn) (*fn)(0, param, current_time(), period); /* initialize */
  return t;
}

void del_task(TASK **tasklist, TASK *tsk)
{
  TASK *t;
  if (tsk == NULL) return;
  if (tsk == *tasklist)
	*tasklist = tsk->next;
  else
	for (t = *tasklist; t; t = t->next)
	  if (t->next == tsk)
	    {
	      t->next = tsk->next;
	      break;
	    }
	free(tsk);
}

void *find_task_data(TASK *task)
{
  return &task->data;
}

void run_tasks(TASK *tasklist)
{
  long now;
  now = current_time();
  for (current_task = tasklist; current_task; current_task = current_task->next)
    {
      if (current_task->fn && (now >= current_task->wakeup))
	{
	  current_task->wakeup = now + current_task->period;
	  current_task->fn(1, NULL, now, current_task->period);
	  current_task->lastran = now;
	}
    }
}

