/* COMPLETELY rewritten by Dave Stampe Dec. 1993, */
/* used to be render.c, now split off to uservid.c and this file */

// This code is the refresh-screen call.  All the other stuff was
// moved to uservid.c
// Also has Dave's axis-compass (much improved) and the new
// prerender/postrender support (implemented in USCREEN.C)

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



/* Contact:  dstampe@sunee.waterloo.edu or broehl@sunee.waterloo.edu or*/

#include <stdio.h>
#include <dos.h>
#include <stdlib.h>	/* labs */

#include "f3dkitd.h"

#include "vr_api.h"
#include "intmath.h"
#include "splits.h"

#define MAIN_VGA  1  /* for multi-VGA only */
#define LEFT_VGA  2
#define RIGHT_VGA 4
#define ALL_VGA   7

#define MONOSCOPIC 0 /* stereo types */
#define SWITCHED   1
#define SPLITLR    3
#define SEPARATE   5

extern struct Screeninfo *screeninfo;

extern int swap_eyes;

extern int show_location, show_compass, show_framerate;  // options
extern int use_glove;

extern void user_draw_line(int x1, int y1, int x2, int y2, int color);



//////////////////////////////////////////
///  THESE ROUTINES LET YOU CONTROL HOW THE
///  SCREEN IS CLEARED AND WHAT IS DISPLAYED
///  THE ARGUMENTS ARE:
///  v : the view being draw.  left/right eye views are different
///  vpage: the video page being drawn
///  isfirst, islast:  1 if this is the first/last access to the
///                    video page.  Useful for toggling screen
///		       clears etc. when several views are on the
///		       same page
///  whicheye:  0 for left eye/mono, 1 for right eye view
///

	// This is called before drawing objects.  It should
	// at least clear the screen

void prerender_process(VIEW *v, WORD vpage, WORD isfirst, WORD whicheye)
{
  extern LIGHT *std_lights[3];
  setup_lights(std_lights,3);
  horizon(v,vpage);   // clear window anyhoo
}


	// This is called after drawing objects.  It can be used
	// to put up status, etc.
	// lots of if() stuff, but just because we're supporting
	// so many stereo types

void postrender_process(VIEW *v, WORD vpage, WORD islast, WORD whicheye)
{
  status_on_screen();

  if(islast)
    {
      coord_ref(screeninfo->xmax-70, screeninfo->ymin+70,35,v,15,13,10,0);
      status_on_screen();
    }

  if (show_framerate && islast)    // display the frame rate
    {
      char c[69];
      sprintf(c,"Frames/sec: %d",get_ticks_per_second()/last_render_time());
      user_text(screeninfo->xmin+5,screeninfo->ymax-20,15,c);
    }

  if (stereo_type==SPLITLR && islast )
    {
//      extern int highest_color;          // split-screen line for windows
//      user_draw_line(splitlx1, splitly1, splitlx2, splitly2, highest_color);
    }

  if(stereo_type==SEPARATE || stereo_type==SWITCHED)  // eye labels
    {
      if(whicheye==LEFT_EYE)
	  user_text(screeninfo->xmin+20,screeninfo->ymin+10,0,"L");
      else
	  user_text(screeninfo->xmax-30,screeninfo->ymin+10,0,"R");
    }

}


int status_on_screen(void)
{
  char buff[100];
  AREA *a, *what_area();
  char *area_name(AREA *);
  POSE p;
  BOOL was_visible = cursor_hide();

  if (show_location == 0) return 0;

  get_camera_worldpose(current_camera,&p);

  sprintf(buff, "Pos(x,z): %ld,%ld", p.x, p.z);
  shadowprint(2,3,15,buff);
  sprintf(buff, "Not in any area");
  a = what_area(global_world_root, body_pose->x, body_pose->y, body_pose->z);
  if (a)
    {
      char *p = area_name(a);
      if (p)
	{
	  sprintf(buff, "Area: %s", p);
	  shadowprint(2,15,15,buff);
	}
    }

  if (use_glove)
    {
      char *c = get_glove_gesture_name();
      if (c)
	{
	  int sl;
	  sprintf(buff,"Glove: %s",c);
	  sl = strlen(buff)<<3;
	  shadowprint(300-sl,3,15,buff);
	}
    }
  if(was_visible) cursor_show();
  return 0;
}

